package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchApplyAdviceByIdList invokes the adb.BatchApplyAdviceByIdList API synchronously
func (client *Client) BatchApplyAdviceByIdList(request *BatchApplyAdviceByIdListRequest) (response *BatchApplyAdviceByIdListResponse, err error) {
	response = CreateBatchApplyAdviceByIdListResponse()
	err = client.DoAction(request, response)
	return
}

// BatchApplyAdviceByIdListWithChan invokes the adb.BatchApplyAdviceByIdList API asynchronously
func (client *Client) BatchApplyAdviceByIdListWithChan(request *BatchApplyAdviceByIdListRequest) (<-chan *BatchApplyAdviceByIdListResponse, <-chan error) {
	responseChan := make(chan *BatchApplyAdviceByIdListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchApplyAdviceByIdList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchApplyAdviceByIdListWithCallback invokes the adb.BatchApplyAdviceByIdList API asynchronously
func (client *Client) BatchApplyAdviceByIdListWithCallback(request *BatchApplyAdviceByIdListRequest, callback func(response *BatchApplyAdviceByIdListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchApplyAdviceByIdListResponse
		var err error
		defer close(result)
		response, err = client.BatchApplyAdviceByIdList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchApplyAdviceByIdListRequest is the request struct for api BatchApplyAdviceByIdList
type BatchApplyAdviceByIdListRequest struct {
	*requests.RpcRequest
	DBClusterId  string           `position:"Query" name:"DBClusterId"`
	AdviceIdList string           `position:"Query" name:"AdviceIdList"`
	AdviceDate   requests.Integer `position:"Query" name:"AdviceDate"`
}

// BatchApplyAdviceByIdListResponse is the response struct for api BatchApplyAdviceByIdList
type BatchApplyAdviceByIdListResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchApplyAdviceByIdListRequest creates a request to invoke BatchApplyAdviceByIdList API
func CreateBatchApplyAdviceByIdListRequest() (request *BatchApplyAdviceByIdListRequest) {
	request = &BatchApplyAdviceByIdListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "BatchApplyAdviceByIdList", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchApplyAdviceByIdListResponse creates a response to parse from BatchApplyAdviceByIdList response
func CreateBatchApplyAdviceByIdListResponse() (response *BatchApplyAdviceByIdListResponse) {
	response = &BatchApplyAdviceByIdListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
