package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableIsolationRule invokes the ahas_openapi.EnableIsolationRule API synchronously
func (client *Client) EnableIsolationRule(request *EnableIsolationRuleRequest) (response *EnableIsolationRuleResponse, err error) {
	response = CreateEnableIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// EnableIsolationRuleWithChan invokes the ahas_openapi.EnableIsolationRule API asynchronously
func (client *Client) EnableIsolationRuleWithChan(request *EnableIsolationRuleRequest) (<-chan *EnableIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *EnableIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableIsolationRuleWithCallback invokes the ahas_openapi.EnableIsolationRule API asynchronously
func (client *Client) EnableIsolationRuleWithCallback(request *EnableIsolationRuleRequest, callback func(response *EnableIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.EnableIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableIsolationRuleRequest is the request struct for api EnableIsolationRule
type EnableIsolationRuleRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	RuleId       requests.Integer `position:"Query" name:"RuleId"`
}

// EnableIsolationRuleResponse is the response struct for api EnableIsolationRule
type EnableIsolationRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEnableIsolationRuleRequest creates a request to invoke EnableIsolationRule API
func CreateEnableIsolationRuleRequest() (request *EnableIsolationRuleRequest) {
	request = &EnableIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "EnableIsolationRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableIsolationRuleResponse creates a response to parse from EnableIsolationRule response
func CreateEnableIsolationRuleResponse() (response *EnableIsolationRuleResponse) {
	response = &EnableIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
