package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenAhasService invokes the ahas_openapi.OpenAhasService API synchronously
func (client *Client) OpenAhasService(request *OpenAhasServiceRequest) (response *OpenAhasServiceResponse, err error) {
	response = CreateOpenAhasServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenAhasServiceWithChan invokes the ahas_openapi.OpenAhasService API asynchronously
func (client *Client) OpenAhasServiceWithChan(request *OpenAhasServiceRequest) (<-chan *OpenAhasServiceResponse, <-chan error) {
	responseChan := make(chan *OpenAhasServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenAhasService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenAhasServiceWithCallback invokes the ahas_openapi.OpenAhasService API asynchronously
func (client *Client) OpenAhasServiceWithCallback(request *OpenAhasServiceRequest, callback func(response *OpenAhasServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenAhasServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenAhasService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenAhasServiceRequest is the request struct for api OpenAhasService
type OpenAhasServiceRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// OpenAhasServiceResponse is the response struct for api OpenAhasService
type OpenAhasServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateOpenAhasServiceRequest creates a request to invoke OpenAhasService API
func CreateOpenAhasServiceRequest() (request *OpenAhasServiceRequest) {
	request = &OpenAhasServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "OpenAhasService", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenAhasServiceResponse creates a response to parse from OpenAhasService response
func CreateOpenAhasServiceResponse() (response *OpenAhasServiceResponse) {
	response = &OpenAhasServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
