package aicontent

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Personalizedtxt2imgAddModelTrainJob invokes the aicontent.Personalizedtxt2imgAddModelTrainJob API synchronously
func (client *Client) Personalizedtxt2imgAddModelTrainJob(request *Personalizedtxt2imgAddModelTrainJobRequest) (response *Personalizedtxt2imgAddModelTrainJobResponse, err error) {
	response = CreatePersonalizedtxt2imgAddModelTrainJobResponse()
	err = client.DoAction(request, response)
	return
}

// Personalizedtxt2imgAddModelTrainJobWithChan invokes the aicontent.Personalizedtxt2imgAddModelTrainJob API asynchronously
func (client *Client) Personalizedtxt2imgAddModelTrainJobWithChan(request *Personalizedtxt2imgAddModelTrainJobRequest) (<-chan *Personalizedtxt2imgAddModelTrainJobResponse, <-chan error) {
	responseChan := make(chan *Personalizedtxt2imgAddModelTrainJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Personalizedtxt2imgAddModelTrainJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Personalizedtxt2imgAddModelTrainJobWithCallback invokes the aicontent.Personalizedtxt2imgAddModelTrainJob API asynchronously
func (client *Client) Personalizedtxt2imgAddModelTrainJobWithCallback(request *Personalizedtxt2imgAddModelTrainJobRequest, callback func(response *Personalizedtxt2imgAddModelTrainJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Personalizedtxt2imgAddModelTrainJobResponse
		var err error
		defer close(result)
		response, err = client.Personalizedtxt2imgAddModelTrainJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Personalizedtxt2imgAddModelTrainJobRequest is the request struct for api Personalizedtxt2imgAddModelTrainJob
type Personalizedtxt2imgAddModelTrainJobRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// Personalizedtxt2imgAddModelTrainJobResponse is the response struct for api Personalizedtxt2imgAddModelTrainJob
type Personalizedtxt2imgAddModelTrainJobResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"requestId" xml:"requestId"`
	Success        bool   `json:"success" xml:"success"`
	ErrCode        string `json:"errCode" xml:"errCode"`
	ErrMessage     string `json:"errMessage" xml:"errMessage"`
	HttpStatusCode int    `json:"httpStatusCode" xml:"httpStatusCode"`
	Data           Data   `json:"data" xml:"data"`
}

// CreatePersonalizedtxt2imgAddModelTrainJobRequest creates a request to invoke Personalizedtxt2imgAddModelTrainJob API
func CreatePersonalizedtxt2imgAddModelTrainJobRequest() (request *Personalizedtxt2imgAddModelTrainJobRequest) {
	request = &Personalizedtxt2imgAddModelTrainJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AiContent", "20240611", "Personalizedtxt2imgAddModelTrainJob", "/api/v1/personalizedtxt2img/addModelTrainJob", "", "")
	request.Method = requests.POST
	return
}

// CreatePersonalizedtxt2imgAddModelTrainJobResponse creates a response to parse from Personalizedtxt2imgAddModelTrainJob response
func CreatePersonalizedtxt2imgAddModelTrainJobResponse() (response *Personalizedtxt2imgAddModelTrainJobResponse) {
	response = &Personalizedtxt2imgAddModelTrainJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
