package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClusterSpecial111 invokes the amp.CreateClusterSpecial111 API synchronously
func (client *Client) CreateClusterSpecial111(request *CreateClusterSpecial111Request) (response *CreateClusterSpecial111Response, err error) {
	response = CreateCreateClusterSpecial111Response()
	err = client.DoAction(request, response)
	return
}

// CreateClusterSpecial111WithChan invokes the amp.CreateClusterSpecial111 API asynchronously
func (client *Client) CreateClusterSpecial111WithChan(request *CreateClusterSpecial111Request) (<-chan *CreateClusterSpecial111Response, <-chan error) {
	responseChan := make(chan *CreateClusterSpecial111Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClusterSpecial111(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterSpecial111WithCallback invokes the amp.CreateClusterSpecial111 API asynchronously
func (client *Client) CreateClusterSpecial111WithCallback(request *CreateClusterSpecial111Request, callback func(response *CreateClusterSpecial111Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterSpecial111Response
		var err error
		defer close(result)
		response, err = client.CreateClusterSpecial111(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterSpecial111Request is the request struct for api CreateClusterSpecial111
type CreateClusterSpecial111Request struct {
	*requests.RoaRequest
	Add1 string `position:"Header" name:"Add1"`
}

// CreateClusterSpecial111Response is the response struct for api CreateClusterSpecial111
type CreateClusterSpecial111Response struct {
	*responses.BaseResponse
	Success string `json:"Success" xml:"Success"`
}

// CreateCreateClusterSpecial111Request creates a request to invoke CreateClusterSpecial111 API
func CreateCreateClusterSpecial111Request() (request *CreateClusterSpecial111Request) {
	request = &CreateClusterSpecial111Request{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "CreateClusterSpecial111", "/clusters/[Cid]/[Pid]/[aaa]/sdasd11/[nnn]", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateClusterSpecial111Response creates a response to parse from CreateClusterSpecial111 response
func CreateCreateClusterSpecial111Response() (response *CreateClusterSpecial111Response) {
	response = &CreateClusterSpecial111Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
