package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestYsWo invokes the amp.TestYsWo API synchronously
func (client *Client) TestYsWo(request *TestYsWoRequest) (response *TestYsWoResponse, err error) {
	response = CreateTestYsWoResponse()
	err = client.DoAction(request, response)
	return
}

// TestYsWoWithChan invokes the amp.TestYsWo API asynchronously
func (client *Client) TestYsWoWithChan(request *TestYsWoRequest) (<-chan *TestYsWoResponse, <-chan error) {
	responseChan := make(chan *TestYsWoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestYsWo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestYsWoWithCallback invokes the amp.TestYsWo API asynchronously
func (client *Client) TestYsWoWithCallback(request *TestYsWoRequest, callback func(response *TestYsWoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestYsWoResponse
		var err error
		defer close(result)
		response, err = client.TestYsWo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestYsWoRequest is the request struct for api TestYsWo
type TestYsWoRequest struct {
	*requests.RoaRequest
	Body TestYsWoBody `position:"Body" name:"body"  type:"Struct"`
}

// TestYsWoBody is a repeated param struct in TestYsWoRequest
type TestYsWoBody struct {
	Id string `name:"Id"`
}

// TestYsWoResponse is the response struct for api TestYsWo
type TestYsWoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateTestYsWoRequest creates a request to invoke TestYsWo API
func CreateTestYsWoRequest() (request *TestYsWoRequest) {
	request = &TestYsWoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "TestYsWo", "/efe/www", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTestYsWoResponse creates a response to parse from TestYsWo response
func CreateTestYsWoResponse() (response *TestYsWoResponse) {
	response = &TestYsWoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
