package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSyntheticTaskDetail invokes the arms.GetSyntheticTaskDetail API synchronously
func (client *Client) GetSyntheticTaskDetail(request *GetSyntheticTaskDetailRequest) (response *GetSyntheticTaskDetailResponse, err error) {
	response = CreateGetSyntheticTaskDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetSyntheticTaskDetailWithChan invokes the arms.GetSyntheticTaskDetail API asynchronously
func (client *Client) GetSyntheticTaskDetailWithChan(request *GetSyntheticTaskDetailRequest) (<-chan *GetSyntheticTaskDetailResponse, <-chan error) {
	responseChan := make(chan *GetSyntheticTaskDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSyntheticTaskDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSyntheticTaskDetailWithCallback invokes the arms.GetSyntheticTaskDetail API asynchronously
func (client *Client) GetSyntheticTaskDetailWithCallback(request *GetSyntheticTaskDetailRequest, callback func(response *GetSyntheticTaskDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSyntheticTaskDetailResponse
		var err error
		defer close(result)
		response, err = client.GetSyntheticTaskDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSyntheticTaskDetailRequest is the request struct for api GetSyntheticTaskDetail
type GetSyntheticTaskDetailRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Query" name:"TaskId"`
}

// GetSyntheticTaskDetailResponse is the response struct for api GetSyntheticTaskDetail
type GetSyntheticTaskDetailResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TaskDetail TaskDetail `json:"TaskDetail" xml:"TaskDetail"`
}

// CreateGetSyntheticTaskDetailRequest creates a request to invoke GetSyntheticTaskDetail API
func CreateGetSyntheticTaskDetailRequest() (request *GetSyntheticTaskDetailRequest) {
	request = &GetSyntheticTaskDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetSyntheticTaskDetail", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSyntheticTaskDetailResponse creates a response to parse from GetSyntheticTaskDetail response
func CreateGetSyntheticTaskDetailResponse() (response *GetSyntheticTaskDetailResponse) {
	response = &GetSyntheticTaskDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
