package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchSyntheticTaskStatus invokes the arms.SwitchSyntheticTaskStatus API synchronously
func (client *Client) SwitchSyntheticTaskStatus(request *SwitchSyntheticTaskStatusRequest) (response *SwitchSyntheticTaskStatusResponse, err error) {
	response = CreateSwitchSyntheticTaskStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchSyntheticTaskStatusWithChan invokes the arms.SwitchSyntheticTaskStatus API asynchronously
func (client *Client) SwitchSyntheticTaskStatusWithChan(request *SwitchSyntheticTaskStatusRequest) (<-chan *SwitchSyntheticTaskStatusResponse, <-chan error) {
	responseChan := make(chan *SwitchSyntheticTaskStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchSyntheticTaskStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchSyntheticTaskStatusWithCallback invokes the arms.SwitchSyntheticTaskStatus API asynchronously
func (client *Client) SwitchSyntheticTaskStatusWithCallback(request *SwitchSyntheticTaskStatusRequest, callback func(response *SwitchSyntheticTaskStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchSyntheticTaskStatusResponse
		var err error
		defer close(result)
		response, err = client.SwitchSyntheticTaskStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchSyntheticTaskStatusRequest is the request struct for api SwitchSyntheticTaskStatus
type SwitchSyntheticTaskStatusRequest struct {
	*requests.RpcRequest
	TaskIds      *[]string        `position:"Query" name:"TaskIds"  type:"Repeated"`
	SwitchStatus requests.Integer `position:"Query" name:"SwitchStatus"`
}

// SwitchSyntheticTaskStatusResponse is the response struct for api SwitchSyntheticTaskStatus
type SwitchSyntheticTaskStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateSwitchSyntheticTaskStatusRequest creates a request to invoke SwitchSyntheticTaskStatus API
func CreateSwitchSyntheticTaskStatusRequest() (request *SwitchSyntheticTaskStatusRequest) {
	request = &SwitchSyntheticTaskStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SwitchSyntheticTaskStatus", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchSyntheticTaskStatusResponse creates a response to parse from SwitchSyntheticTaskStatus response
func CreateSwitchSyntheticTaskStatusResponse() (response *SwitchSyntheticTaskStatusResponse) {
	response = &SwitchSyntheticTaskStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
