package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccessorDomainsStatus invokes the beian.QueryAccessorDomainsStatus API synchronously
func (client *Client) QueryAccessorDomainsStatus(request *QueryAccessorDomainsStatusRequest) (response *QueryAccessorDomainsStatusResponse, err error) {
	response = CreateQueryAccessorDomainsStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccessorDomainsStatusWithChan invokes the beian.QueryAccessorDomainsStatus API asynchronously
func (client *Client) QueryAccessorDomainsStatusWithChan(request *QueryAccessorDomainsStatusRequest) (<-chan *QueryAccessorDomainsStatusResponse, <-chan error) {
	responseChan := make(chan *QueryAccessorDomainsStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccessorDomainsStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccessorDomainsStatusWithCallback invokes the beian.QueryAccessorDomainsStatus API asynchronously
func (client *Client) QueryAccessorDomainsStatusWithCallback(request *QueryAccessorDomainsStatusRequest, callback func(response *QueryAccessorDomainsStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccessorDomainsStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryAccessorDomainsStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccessorDomainsStatusRequest is the request struct for api QueryAccessorDomainsStatus
type QueryAccessorDomainsStatusRequest struct {
	*requests.RpcRequest
	Domains *[]string `position:"Query" name:"Domains"  type:"Repeated"`
	Caller  string    `position:"Query" name:"Caller"`
}

// QueryAccessorDomainsStatusResponse is the response struct for api QueryAccessorDomainsStatus
type QueryAccessorDomainsStatusResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryAccessorDomainsStatusRequest creates a request to invoke QueryAccessorDomainsStatus API
func CreateQueryAccessorDomainsStatusRequest() (request *QueryAccessorDomainsStatusRequest) {
	request = &QueryAccessorDomainsStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "QueryAccessorDomainsStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAccessorDomainsStatusResponse creates a response to parse from QueryAccessorDomainsStatus response
func CreateQueryAccessorDomainsStatusResponse() (response *QueryAccessorDomainsStatusResponse) {
	response = &QueryAccessorDomainsStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
