package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindIpAttribute invokes the biz_ipdb.FindIpAttribute API synchronously
func (client *Client) FindIpAttribute(request *FindIpAttributeRequest) (response *FindIpAttributeResponse, err error) {
	response = CreateFindIpAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// FindIpAttributeWithChan invokes the biz_ipdb.FindIpAttribute API asynchronously
func (client *Client) FindIpAttributeWithChan(request *FindIpAttributeRequest) (<-chan *FindIpAttributeResponse, <-chan error) {
	responseChan := make(chan *FindIpAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindIpAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindIpAttributeWithCallback invokes the biz_ipdb.FindIpAttribute API asynchronously
func (client *Client) FindIpAttributeWithCallback(request *FindIpAttributeRequest, callback func(response *FindIpAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindIpAttributeResponse
		var err error
		defer close(result)
		response, err = client.FindIpAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindIpAttributeRequest is the request struct for api FindIpAttribute
type FindIpAttributeRequest struct {
	*requests.RpcRequest
	Ip string `position:"Query" name:"Ip"`
}

// FindIpAttributeResponse is the response struct for api FindIpAttribute
type FindIpAttributeResponse struct {
	*responses.BaseResponse
	Pod          string                 `json:"Pod" xml:"Pod"`
	HighIp       string                 `json:"HighIp" xml:"HighIp"`
	Cluster      string                 `json:"Cluster" xml:"Cluster"`
	Gateway      string                 `json:"Gateway" xml:"Gateway"`
	SysOwner     string                 `json:"SysOwner" xml:"SysOwner"`
	LowIp        string                 `json:"LowIp" xml:"LowIp"`
	Vlan         string                 `json:"Vlan" xml:"Vlan"`
	RegionId     string                 `json:"RegionId" xml:"RegionId"`
	Value        string                 `json:"Value" xml:"Value"`
	IpType       string                 `json:"IpType" xml:"IpType"`
	RequestId    string                 `json:"RequestId" xml:"RequestId"`
	IpPublic     bool                   `json:"IpPublic" xml:"IpPublic"`
	BizLine      string                 `json:"BizLine" xml:"BizLine"`
	HighIpNumber int64                  `json:"HighIpNumber" xml:"HighIpNumber"`
	Attributes   map[string]interface{} `json:"Attributes" xml:"Attributes"`
	LocationId   string                 `json:"LocationId" xml:"LocationId"`
	LowIpNumber  int64                  `json:"LowIpNumber" xml:"LowIpNumber"`
}

// CreateFindIpAttributeRequest creates a request to invoke FindIpAttribute API
func CreateFindIpAttributeRequest() (request *FindIpAttributeRequest) {
	request = &FindIpAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "FindIpAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateFindIpAttributeResponse creates a response to parse from FindIpAttribute response
func CreateFindIpAttributeResponse() (response *FindIpAttributeResponse) {
	response = &FindIpAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
