package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTraficMatchRuleToTrafficMarkingPolicy invokes the cbn.AddTraficMatchRuleToTrafficMarkingPolicy API synchronously
func (client *Client) AddTraficMatchRuleToTrafficMarkingPolicy(request *AddTraficMatchRuleToTrafficMarkingPolicyRequest) (response *AddTraficMatchRuleToTrafficMarkingPolicyResponse, err error) {
	response = CreateAddTraficMatchRuleToTrafficMarkingPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// AddTraficMatchRuleToTrafficMarkingPolicyWithChan invokes the cbn.AddTraficMatchRuleToTrafficMarkingPolicy API asynchronously
func (client *Client) AddTraficMatchRuleToTrafficMarkingPolicyWithChan(request *AddTraficMatchRuleToTrafficMarkingPolicyRequest) (<-chan *AddTraficMatchRuleToTrafficMarkingPolicyResponse, <-chan error) {
	responseChan := make(chan *AddTraficMatchRuleToTrafficMarkingPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTraficMatchRuleToTrafficMarkingPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTraficMatchRuleToTrafficMarkingPolicyWithCallback invokes the cbn.AddTraficMatchRuleToTrafficMarkingPolicy API asynchronously
func (client *Client) AddTraficMatchRuleToTrafficMarkingPolicyWithCallback(request *AddTraficMatchRuleToTrafficMarkingPolicyRequest, callback func(response *AddTraficMatchRuleToTrafficMarkingPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTraficMatchRuleToTrafficMarkingPolicyResponse
		var err error
		defer close(result)
		response, err = client.AddTraficMatchRuleToTrafficMarkingPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTraficMatchRuleToTrafficMarkingPolicyRequest is the request struct for api AddTraficMatchRuleToTrafficMarkingPolicy
type AddTraficMatchRuleToTrafficMarkingPolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                                             `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string                                                       `position:"Query" name:"ClientToken"`
	TrafficMarkingPolicyId string                                                       `position:"Query" name:"TrafficMarkingPolicyId"`
	DryRun                 requests.Boolean                                             `position:"Query" name:"DryRun"`
	TrafficMatchRules      *[]AddTraficMatchRuleToTrafficMarkingPolicyTrafficMatchRules `position:"Query" name:"TrafficMatchRules"  type:"Repeated"`
	ResourceOwnerAccount   string                                                       `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string                                                       `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer                                             `position:"Query" name:"OwnerId"`
	Version                string                                                       `position:"Query" name:"Version"`
}

// AddTraficMatchRuleToTrafficMarkingPolicyTrafficMatchRules is a repeated param struct in AddTraficMatchRuleToTrafficMarkingPolicyRequest
type AddTraficMatchRuleToTrafficMarkingPolicyTrafficMatchRules struct {
	DstPortRange                *[]string `name:"DstPortRange" type:"Repeated"`
	MatchDscp                   string    `name:"MatchDscp"`
	Protocol                    string    `name:"Protocol"`
	TrafficMatchRuleDescription string    `name:"TrafficMatchRuleDescription"`
	SrcPortRange                *[]string `name:"SrcPortRange" type:"Repeated"`
	DstCidr                     string    `name:"DstCidr"`
	TrafficMatchRuleName        string    `name:"TrafficMatchRuleName"`
	SrcCidr                     string    `name:"SrcCidr"`
}

// AddTraficMatchRuleToTrafficMarkingPolicyResponse is the response struct for api AddTraficMatchRuleToTrafficMarkingPolicy
type AddTraficMatchRuleToTrafficMarkingPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddTraficMatchRuleToTrafficMarkingPolicyRequest creates a request to invoke AddTraficMatchRuleToTrafficMarkingPolicy API
func CreateAddTraficMatchRuleToTrafficMarkingPolicyRequest() (request *AddTraficMatchRuleToTrafficMarkingPolicyRequest) {
	request = &AddTraficMatchRuleToTrafficMarkingPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "AddTraficMatchRuleToTrafficMarkingPolicy", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddTraficMatchRuleToTrafficMarkingPolicyResponse creates a response to parse from AddTraficMatchRuleToTrafficMarkingPolicy response
func CreateAddTraficMatchRuleToTrafficMarkingPolicyResponse() (response *AddTraficMatchRuleToTrafficMarkingPolicyResponse) {
	response = &AddTraficMatchRuleToTrafficMarkingPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
