package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PostEventDisposeAndWhiteruleList invokes the cloud_siem.PostEventDisposeAndWhiteruleList API synchronously
func (client *Client) PostEventDisposeAndWhiteruleList(request *PostEventDisposeAndWhiteruleListRequest) (response *PostEventDisposeAndWhiteruleListResponse, err error) {
	response = CreatePostEventDisposeAndWhiteruleListResponse()
	err = client.DoAction(request, response)
	return
}

// PostEventDisposeAndWhiteruleListWithChan invokes the cloud_siem.PostEventDisposeAndWhiteruleList API asynchronously
func (client *Client) PostEventDisposeAndWhiteruleListWithChan(request *PostEventDisposeAndWhiteruleListRequest) (<-chan *PostEventDisposeAndWhiteruleListResponse, <-chan error) {
	responseChan := make(chan *PostEventDisposeAndWhiteruleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PostEventDisposeAndWhiteruleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PostEventDisposeAndWhiteruleListWithCallback invokes the cloud_siem.PostEventDisposeAndWhiteruleList API asynchronously
func (client *Client) PostEventDisposeAndWhiteruleListWithCallback(request *PostEventDisposeAndWhiteruleListRequest, callback func(response *PostEventDisposeAndWhiteruleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PostEventDisposeAndWhiteruleListResponse
		var err error
		defer close(result)
		response, err = client.PostEventDisposeAndWhiteruleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PostEventDisposeAndWhiteruleListRequest is the request struct for api PostEventDisposeAndWhiteruleList
type PostEventDisposeAndWhiteruleListRequest struct {
	*requests.RpcRequest
	Remark       string           `position:"Body" name:"Remark"`
	EventDispose string           `position:"Body" name:"EventDispose"`
	ReceiverInfo string           `position:"Body" name:"ReceiverInfo"`
	IncidentUuid string           `position:"Body" name:"IncidentUuid"`
	Status       requests.Integer `position:"Body" name:"Status"`
}

// PostEventDisposeAndWhiteruleListResponse is the response struct for api PostEventDisposeAndWhiteruleList
type PostEventDisposeAndWhiteruleListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreatePostEventDisposeAndWhiteruleListRequest creates a request to invoke PostEventDisposeAndWhiteruleList API
func CreatePostEventDisposeAndWhiteruleListRequest() (request *PostEventDisposeAndWhiteruleListRequest) {
	request = &PostEventDisposeAndWhiteruleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "PostEventDisposeAndWhiteruleList", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePostEventDisposeAndWhiteruleListResponse creates a response to parse from PostEventDisposeAndWhiteruleList response
func CreatePostEventDisposeAndWhiteruleListResponse() (response *PostEventDisposeAndWhiteruleListResponse) {
	response = &PostEventDisposeAndWhiteruleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
