package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PostRuleStatusChange invokes the cloud_siem.PostRuleStatusChange API synchronously
func (client *Client) PostRuleStatusChange(request *PostRuleStatusChangeRequest) (response *PostRuleStatusChangeResponse, err error) {
	response = CreatePostRuleStatusChangeResponse()
	err = client.DoAction(request, response)
	return
}

// PostRuleStatusChangeWithChan invokes the cloud_siem.PostRuleStatusChange API asynchronously
func (client *Client) PostRuleStatusChangeWithChan(request *PostRuleStatusChangeRequest) (<-chan *PostRuleStatusChangeResponse, <-chan error) {
	responseChan := make(chan *PostRuleStatusChangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PostRuleStatusChange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PostRuleStatusChangeWithCallback invokes the cloud_siem.PostRuleStatusChange API asynchronously
func (client *Client) PostRuleStatusChangeWithCallback(request *PostRuleStatusChangeRequest, callback func(response *PostRuleStatusChangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PostRuleStatusChangeResponse
		var err error
		defer close(result)
		response, err = client.PostRuleStatusChange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PostRuleStatusChangeRequest is the request struct for api PostRuleStatusChange
type PostRuleStatusChangeRequest struct {
	*requests.RpcRequest
	RuleType string           `position:"Body" name:"RuleType"`
	Ids      string           `position:"Body" name:"Ids"`
	InUse    requests.Boolean `position:"Body" name:"InUse"`
}

// PostRuleStatusChangeResponse is the response struct for api PostRuleStatusChange
type PostRuleStatusChangeResponse struct {
	*responses.BaseResponse
}

// CreatePostRuleStatusChangeRequest creates a request to invoke PostRuleStatusChange API
func CreatePostRuleStatusChangeRequest() (request *PostRuleStatusChangeRequest) {
	request = &PostRuleStatusChangeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "PostRuleStatusChange", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePostRuleStatusChangeResponse creates a response to parse from PostRuleStatusChange response
func CreatePostRuleStatusChangeResponse() (response *PostRuleStatusChangeResponse) {
	response = &PostRuleStatusChangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
