package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceTraffic invokes the cloudapi.DescribeInstanceTraffic API synchronously
func (client *Client) DescribeInstanceTraffic(request *DescribeInstanceTrafficRequest) (response *DescribeInstanceTrafficResponse, err error) {
	response = CreateDescribeInstanceTrafficResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceTrafficWithChan invokes the cloudapi.DescribeInstanceTraffic API asynchronously
func (client *Client) DescribeInstanceTrafficWithChan(request *DescribeInstanceTrafficRequest) (<-chan *DescribeInstanceTrafficResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceTrafficResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceTraffic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceTrafficWithCallback invokes the cloudapi.DescribeInstanceTraffic API asynchronously
func (client *Client) DescribeInstanceTrafficWithCallback(request *DescribeInstanceTrafficRequest, callback func(response *DescribeInstanceTrafficResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceTrafficResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceTraffic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceTrafficRequest is the request struct for api DescribeInstanceTraffic
type DescribeInstanceTrafficRequest struct {
	*requests.RpcRequest
	StageName     string `position:"Query" name:"StageName"`
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeInstanceTrafficResponse is the response struct for api DescribeInstanceTraffic
type DescribeInstanceTrafficResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	InstanceTraffic InstanceTraffic `json:"InstanceTraffic" xml:"InstanceTraffic"`
}

// CreateDescribeInstanceTrafficRequest creates a request to invoke DescribeInstanceTraffic API
func CreateDescribeInstanceTrafficRequest() (request *DescribeInstanceTrafficRequest) {
	request = &DescribeInstanceTrafficRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeInstanceTraffic", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceTrafficResponse creates a response to parse from DescribeInstanceTraffic response
func CreateDescribeInstanceTrafficResponse() (response *DescribeInstanceTrafficResponse) {
	response = &DescribeInstanceTrafficResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
