package cloudauth_console

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetrieveFace invokes the cloudauth_console.RetrieveFace API synchronously
func (client *Client) RetrieveFace(request *RetrieveFaceRequest) (response *RetrieveFaceResponse, err error) {
	response = CreateRetrieveFaceResponse()
	err = client.DoAction(request, response)
	return
}

// RetrieveFaceWithChan invokes the cloudauth_console.RetrieveFace API asynchronously
func (client *Client) RetrieveFaceWithChan(request *RetrieveFaceRequest) (<-chan *RetrieveFaceResponse, <-chan error) {
	responseChan := make(chan *RetrieveFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetrieveFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetrieveFaceWithCallback invokes the cloudauth_console.RetrieveFace API asynchronously
func (client *Client) RetrieveFaceWithCallback(request *RetrieveFaceRequest, callback func(response *RetrieveFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetrieveFaceResponse
		var err error
		defer close(result)
		response, err = client.RetrieveFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetrieveFaceRequest is the request struct for api RetrieveFace
type RetrieveFaceRequest struct {
	*requests.RpcRequest
	Face64String string `position:"Body" name:"Face64String"`
	FaceUrl      string `position:"Query" name:"FaceUrl"`
	ProjectId    string `position:"Query" name:"ProjectId"`
}

// RetrieveFaceResponse is the response struct for api RetrieveFace
type RetrieveFaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRetrieveFaceRequest creates a request to invoke RetrieveFace API
func CreateRetrieveFaceRequest() (request *RetrieveFaceRequest) {
	request = &RetrieveFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth-console", "2019-04-03", "RetrieveFace", "cloudauth-console", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRetrieveFaceResponse creates a response to parse from RetrieveFace response
func CreateRetrieveFaceResponse() (response *RetrieveFaceResponse) {
	response = &RetrieveFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
