package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCompanyTemplateView invokes the cloudesl.DescribeCompanyTemplateView API synchronously
func (client *Client) DescribeCompanyTemplateView(request *DescribeCompanyTemplateViewRequest) (response *DescribeCompanyTemplateViewResponse, err error) {
	response = CreateDescribeCompanyTemplateViewResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCompanyTemplateViewWithChan invokes the cloudesl.DescribeCompanyTemplateView API asynchronously
func (client *Client) DescribeCompanyTemplateViewWithChan(request *DescribeCompanyTemplateViewRequest) (<-chan *DescribeCompanyTemplateViewResponse, <-chan error) {
	responseChan := make(chan *DescribeCompanyTemplateViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCompanyTemplateView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCompanyTemplateViewWithCallback invokes the cloudesl.DescribeCompanyTemplateView API asynchronously
func (client *Client) DescribeCompanyTemplateViewWithCallback(request *DescribeCompanyTemplateViewRequest, callback func(response *DescribeCompanyTemplateViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCompanyTemplateViewResponse
		var err error
		defer close(result)
		response, err = client.DescribeCompanyTemplateView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCompanyTemplateViewRequest is the request struct for api DescribeCompanyTemplateView
type DescribeCompanyTemplateViewRequest struct {
	*requests.RpcRequest
	ExtraParams string `position:"Body" name:"ExtraParams"`
	TemplateId  string `position:"Body" name:"TemplateId"`
}

// DescribeCompanyTemplateViewResponse is the response struct for api DescribeCompanyTemplateView
type DescribeCompanyTemplateViewResponse struct {
	*responses.BaseResponse
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateDescribeCompanyTemplateViewRequest creates a request to invoke DescribeCompanyTemplateView API
func CreateDescribeCompanyTemplateViewRequest() (request *DescribeCompanyTemplateViewRequest) {
	request = &DescribeCompanyTemplateViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeCompanyTemplateView", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCompanyTemplateViewResponse creates a response to parse from DescribeCompanyTemplateView response
func CreateDescribeCompanyTemplateViewResponse() (response *DescribeCompanyTemplateViewResponse) {
	response = &DescribeCompanyTemplateViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
