package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTrFirewallV2RoutePolicyScope invokes the cloudfw.ModifyTrFirewallV2RoutePolicyScope API synchronously
func (client *Client) ModifyTrFirewallV2RoutePolicyScope(request *ModifyTrFirewallV2RoutePolicyScopeRequest) (response *ModifyTrFirewallV2RoutePolicyScopeResponse, err error) {
	response = CreateModifyTrFirewallV2RoutePolicyScopeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTrFirewallV2RoutePolicyScopeWithChan invokes the cloudfw.ModifyTrFirewallV2RoutePolicyScope API asynchronously
func (client *Client) ModifyTrFirewallV2RoutePolicyScopeWithChan(request *ModifyTrFirewallV2RoutePolicyScopeRequest) (<-chan *ModifyTrFirewallV2RoutePolicyScopeResponse, <-chan error) {
	responseChan := make(chan *ModifyTrFirewallV2RoutePolicyScopeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTrFirewallV2RoutePolicyScope(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTrFirewallV2RoutePolicyScopeWithCallback invokes the cloudfw.ModifyTrFirewallV2RoutePolicyScope API asynchronously
func (client *Client) ModifyTrFirewallV2RoutePolicyScopeWithCallback(request *ModifyTrFirewallV2RoutePolicyScopeRequest, callback func(response *ModifyTrFirewallV2RoutePolicyScopeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTrFirewallV2RoutePolicyScopeResponse
		var err error
		defer close(result)
		response, err = client.ModifyTrFirewallV2RoutePolicyScope(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTrFirewallV2RoutePolicyScopeRequest is the request struct for api ModifyTrFirewallV2RoutePolicyScope
type ModifyTrFirewallV2RoutePolicyScopeRequest struct {
	*requests.RpcRequest
	FirewallId              string                                                 `position:"Query" name:"FirewallId"`
	SourceIp                string                                                 `position:"Query" name:"SourceIp"`
	SrcCandidateList        *[]ModifyTrFirewallV2RoutePolicyScopeSrcCandidateList  `position:"Query" name:"SrcCandidateList"  type:"Json"`
	Lang                    string                                                 `position:"Query" name:"Lang"`
	DestCandidateList       *[]ModifyTrFirewallV2RoutePolicyScopeDestCandidateList `position:"Query" name:"DestCandidateList"  type:"Json"`
	TrFirewallRoutePolicyId string                                                 `position:"Query" name:"TrFirewallRoutePolicyId"`
}

// ModifyTrFirewallV2RoutePolicyScopeSrcCandidateList is a repeated param struct in ModifyTrFirewallV2RoutePolicyScopeRequest
type ModifyTrFirewallV2RoutePolicyScopeSrcCandidateList struct {
	CandidateType string `name:"CandidateType"`
	CandidateId   string `name:"CandidateId"`
}

// ModifyTrFirewallV2RoutePolicyScopeDestCandidateList is a repeated param struct in ModifyTrFirewallV2RoutePolicyScopeRequest
type ModifyTrFirewallV2RoutePolicyScopeDestCandidateList struct {
	CandidateType string `name:"CandidateType"`
	CandidateId   string `name:"CandidateId"`
}

// ModifyTrFirewallV2RoutePolicyScopeResponse is the response struct for api ModifyTrFirewallV2RoutePolicyScope
type ModifyTrFirewallV2RoutePolicyScopeResponse struct {
	*responses.BaseResponse
	TrFirewallRoutePolicyId string `json:"TrFirewallRoutePolicyId" xml:"TrFirewallRoutePolicyId"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTrFirewallV2RoutePolicyScopeRequest creates a request to invoke ModifyTrFirewallV2RoutePolicyScope API
func CreateModifyTrFirewallV2RoutePolicyScopeRequest() (request *ModifyTrFirewallV2RoutePolicyScopeRequest) {
	request = &ModifyTrFirewallV2RoutePolicyScopeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyTrFirewallV2RoutePolicyScope", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTrFirewallV2RoutePolicyScopeResponse creates a response to parse from ModifyTrFirewallV2RoutePolicyScope response
func CreateModifyTrFirewallV2RoutePolicyScopeResponse() (response *ModifyTrFirewallV2RoutePolicyScopeResponse) {
	response = &ModifyTrFirewallV2RoutePolicyScopeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
