package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVpcFirewallSwitchStatus invokes the cloudfw.ModifyVpcFirewallSwitchStatus API synchronously
func (client *Client) ModifyVpcFirewallSwitchStatus(request *ModifyVpcFirewallSwitchStatusRequest) (response *ModifyVpcFirewallSwitchStatusResponse, err error) {
	response = CreateModifyVpcFirewallSwitchStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVpcFirewallSwitchStatusWithChan invokes the cloudfw.ModifyVpcFirewallSwitchStatus API asynchronously
func (client *Client) ModifyVpcFirewallSwitchStatusWithChan(request *ModifyVpcFirewallSwitchStatusRequest) (<-chan *ModifyVpcFirewallSwitchStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyVpcFirewallSwitchStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVpcFirewallSwitchStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVpcFirewallSwitchStatusWithCallback invokes the cloudfw.ModifyVpcFirewallSwitchStatus API asynchronously
func (client *Client) ModifyVpcFirewallSwitchStatusWithCallback(request *ModifyVpcFirewallSwitchStatusRequest, callback func(response *ModifyVpcFirewallSwitchStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVpcFirewallSwitchStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyVpcFirewallSwitchStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVpcFirewallSwitchStatusRequest is the request struct for api ModifyVpcFirewallSwitchStatus
type ModifyVpcFirewallSwitchStatusRequest struct {
	*requests.RpcRequest
	FirewallSwitch string `position:"Query" name:"FirewallSwitch"`
	SourceIp       string `position:"Query" name:"SourceIp"`
	MemberUid      string `position:"Query" name:"MemberUid"`
	Lang           string `position:"Query" name:"Lang"`
	VpcFirewallId  string `position:"Query" name:"VpcFirewallId"`
}

// ModifyVpcFirewallSwitchStatusResponse is the response struct for api ModifyVpcFirewallSwitchStatus
type ModifyVpcFirewallSwitchStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVpcFirewallSwitchStatusRequest creates a request to invoke ModifyVpcFirewallSwitchStatus API
func CreateModifyVpcFirewallSwitchStatusRequest() (request *ModifyVpcFirewallSwitchStatusRequest) {
	request = &ModifyVpcFirewallSwitchStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyVpcFirewallSwitchStatus", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVpcFirewallSwitchStatusResponse creates a response to parse from ModifyVpcFirewallSwitchStatus response
func CreateModifyVpcFirewallSwitchStatusResponse() (response *ModifyVpcFirewallSwitchStatusResponse) {
	response = &ModifyVpcFirewallSwitchStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
