package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutDisableAllFwSwitch invokes the cloudfw.PutDisableAllFwSwitch API synchronously
func (client *Client) PutDisableAllFwSwitch(request *PutDisableAllFwSwitchRequest) (response *PutDisableAllFwSwitchResponse, err error) {
	response = CreatePutDisableAllFwSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// PutDisableAllFwSwitchWithChan invokes the cloudfw.PutDisableAllFwSwitch API asynchronously
func (client *Client) PutDisableAllFwSwitchWithChan(request *PutDisableAllFwSwitchRequest) (<-chan *PutDisableAllFwSwitchResponse, <-chan error) {
	responseChan := make(chan *PutDisableAllFwSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutDisableAllFwSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutDisableAllFwSwitchWithCallback invokes the cloudfw.PutDisableAllFwSwitch API asynchronously
func (client *Client) PutDisableAllFwSwitchWithCallback(request *PutDisableAllFwSwitchRequest, callback func(response *PutDisableAllFwSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutDisableAllFwSwitchResponse
		var err error
		defer close(result)
		response, err = client.PutDisableAllFwSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutDisableAllFwSwitchRequest is the request struct for api PutDisableAllFwSwitch
type PutDisableAllFwSwitchRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
}

// PutDisableAllFwSwitchResponse is the response struct for api PutDisableAllFwSwitch
type PutDisableAllFwSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutDisableAllFwSwitchRequest creates a request to invoke PutDisableAllFwSwitch API
func CreatePutDisableAllFwSwitchRequest() (request *PutDisableAllFwSwitchRequest) {
	request = &PutDisableAllFwSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "PutDisableAllFwSwitch", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutDisableAllFwSwitchResponse creates a response to parse from PutDisableAllFwSwitch response
func CreatePutDisableAllFwSwitchResponse() (response *PutDisableAllFwSwitchResponse) {
	response = &PutDisableAllFwSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
