package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGroupMetricRules invokes the cms.CreateGroupMetricRules API synchronously
func (client *Client) CreateGroupMetricRules(request *CreateGroupMetricRulesRequest) (response *CreateGroupMetricRulesResponse, err error) {
	response = CreateCreateGroupMetricRulesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGroupMetricRulesWithChan invokes the cms.CreateGroupMetricRules API asynchronously
func (client *Client) CreateGroupMetricRulesWithChan(request *CreateGroupMetricRulesRequest) (<-chan *CreateGroupMetricRulesResponse, <-chan error) {
	responseChan := make(chan *CreateGroupMetricRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGroupMetricRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGroupMetricRulesWithCallback invokes the cms.CreateGroupMetricRules API asynchronously
func (client *Client) CreateGroupMetricRulesWithCallback(request *CreateGroupMetricRulesRequest, callback func(response *CreateGroupMetricRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGroupMetricRulesResponse
		var err error
		defer close(result)
		response, err = client.CreateGroupMetricRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGroupMetricRulesRequest is the request struct for api CreateGroupMetricRules
type CreateGroupMetricRulesRequest struct {
	*requests.RpcRequest
	GroupId          requests.Integer                          `position:"Query" name:"GroupId"`
	GroupMetricRules *[]CreateGroupMetricRulesGroupMetricRules `position:"Query" name:"GroupMetricRules"  type:"Repeated"`
}

// CreateGroupMetricRulesGroupMetricRules is a repeated param struct in CreateGroupMetricRulesRequest
type CreateGroupMetricRulesGroupMetricRules struct {
	EscalationsInfoN                      string                                          `name:"Escalations.Info.N"`
	Webhook                               string                                          `name:"Webhook"`
	EscalationsWarnComparisonOperator     string                                          `name:"Escalations.Warn.ComparisonOperator"`
	DynamicAlertSensitivity               string                                          `name:"DynamicAlertSensitivity"`
	RuleName                              string                                          `name:"RuleName"`
	EscalationsInfoStatistics             string                                          `name:"Escalations.Info.Statistics"`
	EffectiveInterval                     string                                          `name:"EffectiveInterval"`
	DynamicAlertHistoryDataRange          string                                          `name:"DynamicAlertHistoryDataRange"`
	EscalationsWarnPreCondition           string                                          `name:"Escalations.Warn.PreCondition"`
	EscalationsInfoComparisonOperator     string                                          `name:"Escalations.Info.ComparisonOperator"`
	NoDataPolicy                          string                                          `name:"NoDataPolicy"`
	NoEffectiveInterval                   string                                          `name:"NoEffectiveInterval"`
	EmailSubject                          string                                          `name:"EmailSubject"`
	EscalationsCriticalN                  string                                          `name:"Escalations.Critical.N"`
	SilenceTime                           string                                          `name:"SilenceTime"`
	EscalationsInfoPreCondition           string                                          `name:"Escalations.Info.PreCondition"`
	MetricName                            string                                          `name:"MetricName"`
	EscalationsWarnTimes                  string                                          `name:"Escalations.Warn.Times"`
	CompositeExpression                   string                                          `name:"CompositeExpression"`
	EscalationsWarnThreshold              string                                          `name:"Escalations.Warn.Threshold"`
	Period                                string                                          `name:"Period"`
	ContactGroups                         string                                          `name:"ContactGroups"`
	EscalationsCriticalStatistics         string                                          `name:"Escalations.Critical.Statistics"`
	RuleType                              string                                          `name:"RuleType"`
	EscalationsInfoTimes                  string                                          `name:"Escalations.Info.Times"`
	ExtraDimensionJson                    string                                          `name:"ExtraDimensionJson"`
	Labels                                *[]CreateGroupMetricRulesGroupMetricRulesLabels `name:"Labels" type:"Repeated"`
	EscalationsCriticalTimes              string                                          `name:"Escalations.Critical.Times"`
	EscalationsInfoThreshold              string                                          `name:"Escalations.Info.Threshold"`
	EscalationsWarnStatistics             string                                          `name:"Escalations.Warn.Statistics"`
	Namespace                             string                                          `name:"Namespace"`
	EscalationsWarnN                      string                                          `name:"Escalations.Warn.N"`
	Interval                              string                                          `name:"Interval"`
	RuleId                                string                                          `name:"RuleId"`
	Category                              string                                          `name:"Category"`
	EscalationsCriticalComparisonOperator string                                          `name:"Escalations.Critical.ComparisonOperator"`
	EscalationsCriticalPreCondition       string                                          `name:"Escalations.Critical.PreCondition"`
	EscalationsCriticalThreshold          string                                          `name:"Escalations.Critical.Threshold"`
	Dimensions                            string                                          `name:"Dimensions"`
}

// CreateGroupMetricRulesGroupMetricRulesLabels is a repeated param struct in CreateGroupMetricRulesRequest
type CreateGroupMetricRulesGroupMetricRulesLabels struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateGroupMetricRulesResponse is the response struct for api CreateGroupMetricRules
type CreateGroupMetricRulesResponse struct {
	*responses.BaseResponse
	Code      int                               `json:"Code" xml:"Code"`
	Message   string                            `json:"Message" xml:"Message"`
	RequestId string                            `json:"RequestId" xml:"RequestId"`
	Success   bool                              `json:"Success" xml:"Success"`
	Resources ResourcesInCreateGroupMetricRules `json:"Resources" xml:"Resources"`
}

// CreateCreateGroupMetricRulesRequest creates a request to invoke CreateGroupMetricRules API
func CreateCreateGroupMetricRulesRequest() (request *CreateGroupMetricRulesRequest) {
	request = &CreateGroupMetricRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateGroupMetricRules", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGroupMetricRulesResponse creates a response to parse from CreateGroupMetricRules response
func CreateCreateGroupMetricRulesResponse() (response *CreateGroupMetricRulesResponse) {
	response = &CreateGroupMetricRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
