package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSshKey invokes the codeup.CreateSshKey API synchronously
func (client *Client) CreateSshKey(request *CreateSshKeyRequest) (response *CreateSshKeyResponse, err error) {
	response = CreateCreateSshKeyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSshKeyWithChan invokes the codeup.CreateSshKey API asynchronously
func (client *Client) CreateSshKeyWithChan(request *CreateSshKeyRequest) (<-chan *CreateSshKeyResponse, <-chan error) {
	responseChan := make(chan *CreateSshKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSshKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSshKeyWithCallback invokes the codeup.CreateSshKey API asynchronously
func (client *Client) CreateSshKeyWithCallback(request *CreateSshKeyRequest, callback func(response *CreateSshKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSshKeyResponse
		var err error
		defer close(result)
		response, err = client.CreateSshKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSshKeyRequest is the request struct for api CreateSshKey
type CreateSshKeyRequest struct {
	*requests.RoaRequest
	AccessToken string `position:"Query" name:"AccessToken"`
}

// CreateSshKeyResponse is the response struct for api CreateSshKey
type CreateSshKeyResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateCreateSshKeyRequest creates a request to invoke CreateSshKey API
func CreateCreateSshKeyRequest() (request *CreateSshKeyRequest) {
	request = &CreateSshKeyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "CreateSshKey", "/api/v3/user/keys", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSshKeyResponse creates a response to parse from CreateSshKey response
func CreateCreateSshKeyResponse() (response *CreateSshKeyResponse) {
	response = &CreateSshKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
