package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryBidUserCertifiedInfo invokes the crm.QueryBidUserCertifiedInfo API synchronously
// api document: https://help.aliyun.com/api/crm/querybidusercertifiedinfo.html
func (client *Client) QueryBidUserCertifiedInfo(request *QueryBidUserCertifiedInfoRequest) (response *QueryBidUserCertifiedInfoResponse, err error) {
	response = CreateQueryBidUserCertifiedInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryBidUserCertifiedInfoWithChan invokes the crm.QueryBidUserCertifiedInfo API asynchronously
// api document: https://help.aliyun.com/api/crm/querybidusercertifiedinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryBidUserCertifiedInfoWithChan(request *QueryBidUserCertifiedInfoRequest) (<-chan *QueryBidUserCertifiedInfoResponse, <-chan error) {
	responseChan := make(chan *QueryBidUserCertifiedInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryBidUserCertifiedInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryBidUserCertifiedInfoWithCallback invokes the crm.QueryBidUserCertifiedInfo API asynchronously
// api document: https://help.aliyun.com/api/crm/querybidusercertifiedinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryBidUserCertifiedInfoWithCallback(request *QueryBidUserCertifiedInfoRequest, callback func(response *QueryBidUserCertifiedInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryBidUserCertifiedInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryBidUserCertifiedInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryBidUserCertifiedInfoRequest is the request struct for api QueryBidUserCertifiedInfo
type QueryBidUserCertifiedInfoRequest struct {
	*requests.RpcRequest
	BidType string `position:"Query" name:"BidType"`
	PK      string `position:"Query" name:"PK"`
}

// QueryBidUserCertifiedInfoResponse is the response struct for api QueryBidUserCertifiedInfo
type QueryBidUserCertifiedInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateQueryBidUserCertifiedInfoRequest creates a request to invoke QueryBidUserCertifiedInfo API
func CreateQueryBidUserCertifiedInfoRequest() (request *QueryBidUserCertifiedInfoRequest) {
	request = &QueryBidUserCertifiedInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "QueryBidUserCertifiedInfo", "crm", "openAPI")
	return
}

// CreateQueryBidUserCertifiedInfoResponse creates a response to parse from QueryBidUserCertifiedInfo response
func CreateQueryBidUserCertifiedInfoResponse() (response *QueryBidUserCertifiedInfoResponse) {
	response = &QueryBidUserCertifiedInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
