package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachApplication2Connector invokes the csas.AttachApplication2Connector API synchronously
func (client *Client) AttachApplication2Connector(request *AttachApplication2ConnectorRequest) (response *AttachApplication2ConnectorResponse, err error) {
	response = CreateAttachApplication2ConnectorResponse()
	err = client.DoAction(request, response)
	return
}

// AttachApplication2ConnectorWithChan invokes the csas.AttachApplication2Connector API asynchronously
func (client *Client) AttachApplication2ConnectorWithChan(request *AttachApplication2ConnectorRequest) (<-chan *AttachApplication2ConnectorResponse, <-chan error) {
	responseChan := make(chan *AttachApplication2ConnectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachApplication2Connector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachApplication2ConnectorWithCallback invokes the csas.AttachApplication2Connector API asynchronously
func (client *Client) AttachApplication2ConnectorWithCallback(request *AttachApplication2ConnectorRequest, callback func(response *AttachApplication2ConnectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachApplication2ConnectorResponse
		var err error
		defer close(result)
		response, err = client.AttachApplication2Connector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachApplication2ConnectorRequest is the request struct for api AttachApplication2Connector
type AttachApplication2ConnectorRequest struct {
	*requests.RpcRequest
	ConnectorId    string    `position:"Body" name:"ConnectorId"`
	ApplicationIds *[]string `position:"Body" name:"ApplicationIds"  type:"Json"`
	SourceIp       string    `position:"Query" name:"SourceIp"`
}

// AttachApplication2ConnectorResponse is the response struct for api AttachApplication2Connector
type AttachApplication2ConnectorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachApplication2ConnectorRequest creates a request to invoke AttachApplication2Connector API
func CreateAttachApplication2ConnectorRequest() (request *AttachApplication2ConnectorRequest) {
	request = &AttachApplication2ConnectorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "AttachApplication2Connector", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachApplication2ConnectorResponse creates a response to parse from AttachApplication2Connector response
func CreateAttachApplication2ConnectorResponse() (response *AttachApplication2ConnectorResponse) {
	response = &AttachApplication2ConnectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
