package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserApplications invokes the csas.ListUserApplications API synchronously
func (client *Client) ListUserApplications(request *ListUserApplicationsRequest) (response *ListUserApplicationsResponse, err error) {
	response = CreateListUserApplicationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserApplicationsWithChan invokes the csas.ListUserApplications API asynchronously
func (client *Client) ListUserApplicationsWithChan(request *ListUserApplicationsRequest) (<-chan *ListUserApplicationsResponse, <-chan error) {
	responseChan := make(chan *ListUserApplicationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserApplications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserApplicationsWithCallback invokes the csas.ListUserApplications API asynchronously
func (client *Client) ListUserApplicationsWithCallback(request *ListUserApplicationsRequest, callback func(response *ListUserApplicationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserApplicationsResponse
		var err error
		defer close(result)
		response, err = client.ListUserApplications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserApplicationsRequest is the request struct for api ListUserApplications
type ListUserApplicationsRequest struct {
	*requests.RpcRequest
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	SaseUserId  string           `position:"Query" name:"SaseUserId"`
	Name        string           `position:"Query" name:"Name"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListUserApplicationsResponse is the response struct for api ListUserApplications
type ListUserApplicationsResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	TotalNum     int                `json:"TotalNum" xml:"TotalNum"`
	Applications []ApplicationsItem `json:"Applications" xml:"Applications"`
}

// CreateListUserApplicationsRequest creates a request to invoke ListUserApplications API
func CreateListUserApplicationsRequest() (request *ListUserApplicationsRequest) {
	request = &ListUserApplicationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListUserApplications", "", "")
	request.Method = requests.GET
	return
}

// CreateListUserApplicationsResponse creates a response to parse from ListUserApplications response
func CreateListUserApplicationsResponse() (response *ListUserApplicationsResponse) {
	response = &ListUserApplicationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
