package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBusiness invokes the dataworks_public.CreateBusiness API synchronously
func (client *Client) CreateBusiness(request *CreateBusinessRequest) (response *CreateBusinessResponse, err error) {
	response = CreateCreateBusinessResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBusinessWithChan invokes the dataworks_public.CreateBusiness API asynchronously
func (client *Client) CreateBusinessWithChan(request *CreateBusinessRequest) (<-chan *CreateBusinessResponse, <-chan error) {
	responseChan := make(chan *CreateBusinessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBusiness(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBusinessWithCallback invokes the dataworks_public.CreateBusiness API asynchronously
func (client *Client) CreateBusinessWithCallback(request *CreateBusinessRequest, callback func(response *CreateBusinessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBusinessResponse
		var err error
		defer close(result)
		response, err = client.CreateBusiness(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBusinessRequest is the request struct for api CreateBusiness
type CreateBusinessRequest struct {
	*requests.RpcRequest
	Owner             string           `position:"Body" name:"Owner"`
	Description       string           `position:"Body" name:"Description"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
	BusinessName      string           `position:"Body" name:"BusinessName"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	UseType           string           `position:"Body" name:"UseType"`
}

// CreateBusinessResponse is the response struct for api CreateBusiness
type CreateBusinessResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	BusinessId     int64  `json:"BusinessId" xml:"BusinessId"`
}

// CreateCreateBusinessRequest creates a request to invoke CreateBusiness API
func CreateCreateBusinessRequest() (request *CreateBusinessRequest) {
	request = &CreateBusinessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateBusiness", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateBusinessResponse creates a response to parse from CreateBusiness response
func CreateCreateBusinessResponse() (response *CreateBusinessResponse) {
	response = &CreateBusinessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
