package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListManualDagInstances invokes the dataworks_public.ListManualDagInstances API synchronously
func (client *Client) ListManualDagInstances(request *ListManualDagInstancesRequest) (response *ListManualDagInstancesResponse, err error) {
	response = CreateListManualDagInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListManualDagInstancesWithChan invokes the dataworks_public.ListManualDagInstances API asynchronously
func (client *Client) ListManualDagInstancesWithChan(request *ListManualDagInstancesRequest) (<-chan *ListManualDagInstancesResponse, <-chan error) {
	responseChan := make(chan *ListManualDagInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListManualDagInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListManualDagInstancesWithCallback invokes the dataworks_public.ListManualDagInstances API asynchronously
func (client *Client) ListManualDagInstancesWithCallback(request *ListManualDagInstancesRequest, callback func(response *ListManualDagInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListManualDagInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListManualDagInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListManualDagInstancesRequest is the request struct for api ListManualDagInstances
type ListManualDagInstancesRequest struct {
	*requests.RpcRequest
	ProjectEnv  string `position:"Body" name:"ProjectEnv"`
	ProjectName string `position:"Body" name:"ProjectName"`
	DagId       string `position:"Body" name:"DagId"`
}

// ListManualDagInstancesResponse is the response struct for api ListManualDagInstances
type ListManualDagInstancesResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Instances []InstancesItem `json:"Instances" xml:"Instances"`
}

// CreateListManualDagInstancesRequest creates a request to invoke ListManualDagInstances API
func CreateListManualDagInstancesRequest() (request *ListManualDagInstancesRequest) {
	request = &ListManualDagInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListManualDagInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateListManualDagInstancesResponse creates a response to parse from ListManualDagInstances response
func CreateListManualDagInstancesResponse() (response *ListManualDagInstancesResponse) {
	response = &ListManualDagInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
