package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySensLevel invokes the dataworks_public.QuerySensLevel API synchronously
func (client *Client) QuerySensLevel(request *QuerySensLevelRequest) (response *QuerySensLevelResponse, err error) {
	response = CreateQuerySensLevelResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySensLevelWithChan invokes the dataworks_public.QuerySensLevel API asynchronously
func (client *Client) QuerySensLevelWithChan(request *QuerySensLevelRequest) (<-chan *QuerySensLevelResponse, <-chan error) {
	responseChan := make(chan *QuerySensLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySensLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySensLevelWithCallback invokes the dataworks_public.QuerySensLevel API asynchronously
func (client *Client) QuerySensLevelWithCallback(request *QuerySensLevelRequest, callback func(response *QuerySensLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySensLevelResponse
		var err error
		defer close(result)
		response, err = client.QuerySensLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySensLevelRequest is the request struct for api QuerySensLevel
type QuerySensLevelRequest struct {
	*requests.RpcRequest
	TenantId   string `position:"Body" name:"tenantId"`
	TemplateId string `position:"Body" name:"TemplateId"`
}

// QuerySensLevelResponse is the response struct for api QuerySensLevel
type QuerySensLevelResponse struct {
	*responses.BaseResponse
}

// CreateQuerySensLevelRequest creates a request to invoke QuerySensLevel API
func CreateQuerySensLevelRequest() (request *QuerySensLevelRequest) {
	request = &QuerySensLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "QuerySensLevel", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySensLevelResponse creates a response to parse from QuerySensLevel response
func CreateQuerySensLevelResponse() (response *QuerySensLevelResponse) {
	response = &QuerySensLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
