package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnIpaDomainCidr invokes the dcdn.DescribeDcdnIpaDomainCidr API synchronously
func (client *Client) DescribeDcdnIpaDomainCidr(request *DescribeDcdnIpaDomainCidrRequest) (response *DescribeDcdnIpaDomainCidrResponse, err error) {
	response = CreateDescribeDcdnIpaDomainCidrResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnIpaDomainCidrWithChan invokes the dcdn.DescribeDcdnIpaDomainCidr API asynchronously
func (client *Client) DescribeDcdnIpaDomainCidrWithChan(request *DescribeDcdnIpaDomainCidrRequest) (<-chan *DescribeDcdnIpaDomainCidrResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnIpaDomainCidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnIpaDomainCidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnIpaDomainCidrWithCallback invokes the dcdn.DescribeDcdnIpaDomainCidr API asynchronously
func (client *Client) DescribeDcdnIpaDomainCidrWithCallback(request *DescribeDcdnIpaDomainCidrRequest, callback func(response *DescribeDcdnIpaDomainCidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnIpaDomainCidrResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnIpaDomainCidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnIpaDomainCidrRequest is the request struct for api DescribeDcdnIpaDomainCidr
type DescribeDcdnIpaDomainCidrRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
}

// DescribeDcdnIpaDomainCidrResponse is the response struct for api DescribeDcdnIpaDomainCidr
type DescribeDcdnIpaDomainCidrResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Cidr      []string `json:"Cidr" xml:"Cidr"`
}

// CreateDescribeDcdnIpaDomainCidrRequest creates a request to invoke DescribeDcdnIpaDomainCidr API
func CreateDescribeDcdnIpaDomainCidrRequest() (request *DescribeDcdnIpaDomainCidrRequest) {
	request = &DescribeDcdnIpaDomainCidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnIpaDomainCidr", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnIpaDomainCidrResponse creates a response to parse from DescribeDcdnIpaDomainCidr response
func CreateDescribeDcdnIpaDomainCidrResponse() (response *DescribeDcdnIpaDomainCidrResponse) {
	response = &DescribeDcdnIpaDomainCidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
