package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnUserCertificateExpireCount invokes the dcdn.DescribeDcdnUserCertificateExpireCount API synchronously
func (client *Client) DescribeDcdnUserCertificateExpireCount(request *DescribeDcdnUserCertificateExpireCountRequest) (response *DescribeDcdnUserCertificateExpireCountResponse, err error) {
	response = CreateDescribeDcdnUserCertificateExpireCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnUserCertificateExpireCountWithChan invokes the dcdn.DescribeDcdnUserCertificateExpireCount API asynchronously
func (client *Client) DescribeDcdnUserCertificateExpireCountWithChan(request *DescribeDcdnUserCertificateExpireCountRequest) (<-chan *DescribeDcdnUserCertificateExpireCountResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnUserCertificateExpireCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnUserCertificateExpireCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnUserCertificateExpireCountWithCallback invokes the dcdn.DescribeDcdnUserCertificateExpireCount API asynchronously
func (client *Client) DescribeDcdnUserCertificateExpireCountWithCallback(request *DescribeDcdnUserCertificateExpireCountRequest, callback func(response *DescribeDcdnUserCertificateExpireCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnUserCertificateExpireCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnUserCertificateExpireCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnUserCertificateExpireCountRequest is the request struct for api DescribeDcdnUserCertificateExpireCount
type DescribeDcdnUserCertificateExpireCountRequest struct {
	*requests.RpcRequest
}

// DescribeDcdnUserCertificateExpireCountResponse is the response struct for api DescribeDcdnUserCertificateExpireCount
type DescribeDcdnUserCertificateExpireCountResponse struct {
	*responses.BaseResponse
	ExpireWithin30DaysCount int    `json:"ExpireWithin30DaysCount" xml:"ExpireWithin30DaysCount"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
	ExpiredCount            int    `json:"ExpiredCount" xml:"ExpiredCount"`
}

// CreateDescribeDcdnUserCertificateExpireCountRequest creates a request to invoke DescribeDcdnUserCertificateExpireCount API
func CreateDescribeDcdnUserCertificateExpireCountRequest() (request *DescribeDcdnUserCertificateExpireCountRequest) {
	request = &DescribeDcdnUserCertificateExpireCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnUserCertificateExpireCount", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnUserCertificateExpireCountResponse creates a response to parse from DescribeDcdnUserCertificateExpireCount response
func CreateDescribeDcdnUserCertificateExpireCountResponse() (response *DescribeDcdnUserCertificateExpireCountResponse) {
	response = &DescribeDcdnUserCertificateExpireCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
