package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRDDomains invokes the dcdn.DescribeRDDomains API synchronously
func (client *Client) DescribeRDDomains(request *DescribeRDDomainsRequest) (response *DescribeRDDomainsResponse, err error) {
	response = CreateDescribeRDDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRDDomainsWithChan invokes the dcdn.DescribeRDDomains API asynchronously
func (client *Client) DescribeRDDomainsWithChan(request *DescribeRDDomainsRequest) (<-chan *DescribeRDDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeRDDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRDDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRDDomainsWithCallback invokes the dcdn.DescribeRDDomains API asynchronously
func (client *Client) DescribeRDDomainsWithCallback(request *DescribeRDDomainsRequest, callback func(response *DescribeRDDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRDDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRDDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRDDomainsRequest is the request struct for api DescribeRDDomains
type DescribeRDDomainsRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeRDDomainsResponse is the response struct for api DescribeRDDomains
type DescribeRDDomainsResponse struct {
	*responses.BaseResponse
	RequestId  string                     `json:"RequestId" xml:"RequestId"`
	PageNumber int64                      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64                      `json:"PageSize" xml:"PageSize"`
	TotalCount int64                      `json:"TotalCount" xml:"TotalCount"`
	Domains    DomainsInDescribeRDDomains `json:"Domains" xml:"Domains"`
}

// CreateDescribeRDDomainsRequest creates a request to invoke DescribeRDDomains API
func CreateDescribeRDDomainsRequest() (request *DescribeRDDomainsRequest) {
	request = &DescribeRDDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeRDDomains", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRDDomainsResponse creates a response to parse from DescribeRDDomains response
func CreateDescribeRDDomainsResponse() (response *DescribeRDDomainsResponse) {
	response = &DescribeRDDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
