package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceIds invokes the ddoscoo.DescribeInstanceIds API synchronously
func (client *Client) DescribeInstanceIds(request *DescribeInstanceIdsRequest) (response *DescribeInstanceIdsResponse, err error) {
	response = CreateDescribeInstanceIdsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceIdsWithChan invokes the ddoscoo.DescribeInstanceIds API asynchronously
func (client *Client) DescribeInstanceIdsWithChan(request *DescribeInstanceIdsRequest) (<-chan *DescribeInstanceIdsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceIdsWithCallback invokes the ddoscoo.DescribeInstanceIds API asynchronously
func (client *Client) DescribeInstanceIdsWithCallback(request *DescribeInstanceIdsRequest, callback func(response *DescribeInstanceIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceIdsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceIdsRequest is the request struct for api DescribeInstanceIds
type DescribeInstanceIdsRequest struct {
	*requests.RpcRequest
	Edition         requests.Integer `position:"Query" name:"Edition"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// DescribeInstanceIdsResponse is the response struct for api DescribeInstanceIds
type DescribeInstanceIdsResponse struct {
	*responses.BaseResponse
	RequestId   string     `json:"RequestId" xml:"RequestId"`
	InstanceIds []Instance `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateDescribeInstanceIdsRequest creates a request to invoke DescribeInstanceIds API
func CreateDescribeInstanceIdsRequest() (request *DescribeInstanceIdsRequest) {
	request = &DescribeInstanceIdsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeInstanceIds", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceIdsResponse creates a response to parse from DescribeInstanceIds response
func CreateDescribeInstanceIdsResponse() (response *DescribeInstanceIdsResponse) {
	response = &DescribeInstanceIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
