package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAvailabilityZones invokes the dds.DescribeAvailabilityZones API synchronously
func (client *Client) DescribeAvailabilityZones(request *DescribeAvailabilityZonesRequest) (response *DescribeAvailabilityZonesResponse, err error) {
	response = CreateDescribeAvailabilityZonesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAvailabilityZonesWithChan invokes the dds.DescribeAvailabilityZones API asynchronously
func (client *Client) DescribeAvailabilityZonesWithChan(request *DescribeAvailabilityZonesRequest) (<-chan *DescribeAvailabilityZonesResponse, <-chan error) {
	responseChan := make(chan *DescribeAvailabilityZonesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAvailabilityZones(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAvailabilityZonesWithCallback invokes the dds.DescribeAvailabilityZones API asynchronously
func (client *Client) DescribeAvailabilityZonesWithCallback(request *DescribeAvailabilityZonesRequest, callback func(response *DescribeAvailabilityZonesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAvailabilityZonesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAvailabilityZones(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAvailabilityZonesRequest is the request struct for api DescribeAvailabilityZones
type DescribeAvailabilityZonesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EngineVersion          string           `position:"Query" name:"EngineVersion"`
	StorageType            string           `position:"Query" name:"StorageType"`
	ReplicationFactor      string           `position:"Query" name:"ReplicationFactor"`
	ResourceGroupId        string           `position:"Query" name:"ResourceGroupId"`
	ExcludeZoneId          string           `position:"Query" name:"ExcludeZoneId"`
	ExcludeSecondaryZoneId string           `position:"Query" name:"ExcludeSecondaryZoneId"`
	InstanceChargeType     string           `position:"Query" name:"InstanceChargeType"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	Level                  string           `position:"Query" name:"Level"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	MongoType              string           `position:"Query" name:"MongoType"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceClass        string           `position:"Query" name:"DBInstanceClass"`
	StorageSupport         string           `position:"Query" name:"StorageSupport"`
	DbType                 string           `position:"Query" name:"DbType"`
	AcceptLanguage         string           `position:"Query" name:"AcceptLanguage"`
	ZoneId                 string           `position:"Query" name:"ZoneId"`
}

// DescribeAvailabilityZonesResponse is the response struct for api DescribeAvailabilityZones
type DescribeAvailabilityZonesResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	AvailableZones []AvailableZone `json:"AvailableZones" xml:"AvailableZones"`
}

// CreateDescribeAvailabilityZonesRequest creates a request to invoke DescribeAvailabilityZones API
func CreateDescribeAvailabilityZonesRequest() (request *DescribeAvailabilityZonesRequest) {
	request = &DescribeAvailabilityZonesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeAvailabilityZones", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAvailabilityZonesResponse creates a response to parse from DescribeAvailabilityZones response
func CreateDescribeAvailabilityZonesResponse() (response *DescribeAvailabilityZonesResponse) {
	response = &DescribeAvailabilityZonesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
