package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartNode invokes the dds.RestartNode API synchronously
func (client *Client) RestartNode(request *RestartNodeRequest) (response *RestartNodeResponse, err error) {
	response = CreateRestartNodeResponse()
	err = client.DoAction(request, response)
	return
}

// RestartNodeWithChan invokes the dds.RestartNode API asynchronously
func (client *Client) RestartNodeWithChan(request *RestartNodeRequest) (<-chan *RestartNodeResponse, <-chan error) {
	responseChan := make(chan *RestartNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartNodeWithCallback invokes the dds.RestartNode API asynchronously
func (client *Client) RestartNodeWithCallback(request *RestartNodeRequest, callback func(response *RestartNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartNodeResponse
		var err error
		defer close(result)
		response, err = client.RestartNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartNodeRequest is the request struct for api RestartNode
type RestartNodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RoleId               string           `position:"Query" name:"RoleId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	NodeId               string           `position:"Query" name:"NodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// RestartNodeResponse is the response struct for api RestartNode
type RestartNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRestartNodeRequest creates a request to invoke RestartNode API
func CreateRestartNodeRequest() (request *RestartNodeRequest) {
	request = &RestartNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "RestartNode", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartNodeResponse creates a response to parse from RestartNode response
func CreateRestartNodeResponse() (response *RestartNodeResponse) {
	response = &RestartNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
