package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForAssociatingEns invokes the domain.SaveSingleTaskForAssociatingEns API synchronously
func (client *Client) SaveSingleTaskForAssociatingEns(request *SaveSingleTaskForAssociatingEnsRequest) (response *SaveSingleTaskForAssociatingEnsResponse, err error) {
	response = CreateSaveSingleTaskForAssociatingEnsResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForAssociatingEnsWithChan invokes the domain.SaveSingleTaskForAssociatingEns API asynchronously
func (client *Client) SaveSingleTaskForAssociatingEnsWithChan(request *SaveSingleTaskForAssociatingEnsRequest) (<-chan *SaveSingleTaskForAssociatingEnsResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForAssociatingEnsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForAssociatingEns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForAssociatingEnsWithCallback invokes the domain.SaveSingleTaskForAssociatingEns API asynchronously
func (client *Client) SaveSingleTaskForAssociatingEnsWithCallback(request *SaveSingleTaskForAssociatingEnsRequest, callback func(response *SaveSingleTaskForAssociatingEnsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForAssociatingEnsResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForAssociatingEns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForAssociatingEnsRequest is the request struct for api SaveSingleTaskForAssociatingEns
type SaveSingleTaskForAssociatingEnsRequest struct {
	*requests.RpcRequest
	Address      string `position:"Query" name:"Address"`
	DomainName   string `position:"Query" name:"DomainName"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// SaveSingleTaskForAssociatingEnsResponse is the response struct for api SaveSingleTaskForAssociatingEns
type SaveSingleTaskForAssociatingEnsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForAssociatingEnsRequest creates a request to invoke SaveSingleTaskForAssociatingEns API
func CreateSaveSingleTaskForAssociatingEnsRequest() (request *SaveSingleTaskForAssociatingEnsRequest) {
	request = &SaveSingleTaskForAssociatingEnsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForAssociatingEns", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForAssociatingEnsResponse creates a response to parse from SaveSingleTaskForAssociatingEns response
func CreateSaveSingleTaskForAssociatingEnsResponse() (response *SaveSingleTaskForAssociatingEnsResponse) {
	response = &SaveSingleTaskForAssociatingEnsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
