package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryExtCodeSign invokes the dysmsapi.QueryExtCodeSign API synchronously
func (client *Client) QueryExtCodeSign(request *QueryExtCodeSignRequest) (response *QueryExtCodeSignResponse, err error) {
	response = CreateQueryExtCodeSignResponse()
	err = client.DoAction(request, response)
	return
}

// QueryExtCodeSignWithChan invokes the dysmsapi.QueryExtCodeSign API asynchronously
func (client *Client) QueryExtCodeSignWithChan(request *QueryExtCodeSignRequest) (<-chan *QueryExtCodeSignResponse, <-chan error) {
	responseChan := make(chan *QueryExtCodeSignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryExtCodeSign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryExtCodeSignWithCallback invokes the dysmsapi.QueryExtCodeSign API asynchronously
func (client *Client) QueryExtCodeSignWithCallback(request *QueryExtCodeSignRequest, callback func(response *QueryExtCodeSignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryExtCodeSignResponse
		var err error
		defer close(result)
		response, err = client.QueryExtCodeSign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryExtCodeSignRequest is the request struct for api QueryExtCodeSign
type QueryExtCodeSignRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LowcodeTenantId      string           `position:"Query" name:"LowcodeTenantId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	LowcodePhysicAppName string           `position:"Query" name:"LowcodePhysicAppName"`
	SignName             string           `position:"Query" name:"SignName"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ExtCode              string           `position:"Query" name:"ExtCode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	LowcodeLogicAppName  string           `position:"Query" name:"LowcodeLogicAppName"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
}

// QueryExtCodeSignResponse is the response struct for api QueryExtCodeSign
type QueryExtCodeSignResponse struct {
	*responses.BaseResponse
	AccessDeniedDetail string `json:"AccessDeniedDetail" xml:"AccessDeniedDetail"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Message            string `json:"Message" xml:"Message"`
	Code               string `json:"Code" xml:"Code"`
	Success            bool   `json:"Success" xml:"Success"`
	Data               Data   `json:"Data" xml:"Data"`
}

// CreateQueryExtCodeSignRequest creates a request to invoke QueryExtCodeSign API
func CreateQueryExtCodeSignRequest() (request *QueryExtCodeSignRequest) {
	request = &QueryExtCodeSignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "QueryExtCodeSign", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryExtCodeSignResponse creates a response to parse from QueryExtCodeSign response
func CreateQueryExtCodeSignResponse() (response *QueryExtCodeSignResponse) {
	response = &QueryExtCodeSignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
