package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskEvents invokes the ebs.DescribeDiskEvents API synchronously
func (client *Client) DescribeDiskEvents(request *DescribeDiskEventsRequest) (response *DescribeDiskEventsResponse, err error) {
	response = CreateDescribeDiskEventsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskEventsWithChan invokes the ebs.DescribeDiskEvents API asynchronously
func (client *Client) DescribeDiskEventsWithChan(request *DescribeDiskEventsRequest) (<-chan *DescribeDiskEventsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskEventsWithCallback invokes the ebs.DescribeDiskEvents API asynchronously
func (client *Client) DescribeDiskEventsWithCallback(request *DescribeDiskEventsRequest, callback func(response *DescribeDiskEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskEventsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskEventsRequest is the request struct for api DescribeDiskEvents
type DescribeDiskEventsRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	Type         string           `position:"Query" name:"Type"`
	NextToken    string           `position:"Query" name:"NextToken"`
	DiskCategory string           `position:"Query" name:"DiskCategory"`
	DiskId       string           `position:"Query" name:"DiskId"`
	EndTime      string           `position:"Query" name:"EndTime"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeDiskEventsResponse is the response struct for api DescribeDiskEvents
type DescribeDiskEventsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount int64       `json:"TotalCount" xml:"TotalCount"`
	NextToken  string      `json:"NextToken" xml:"NextToken"`
	DiskEvents []DiskEvent `json:"DiskEvents" xml:"DiskEvents"`
}

// CreateDescribeDiskEventsRequest creates a request to invoke DescribeDiskEvents API
func CreateDescribeDiskEventsRequest() (request *DescribeDiskEventsRequest) {
	request = &DescribeDiskEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeDiskEvents", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskEventsResponse creates a response to parse from DescribeDiskEvents response
func CreateDescribeDiskEventsResponse() (response *DescribeDiskEventsResponse) {
	response = &DescribeDiskEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
