package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDiskMonitor invokes the ebs.StopDiskMonitor API synchronously
func (client *Client) StopDiskMonitor(request *StopDiskMonitorRequest) (response *StopDiskMonitorResponse, err error) {
	response = CreateStopDiskMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// StopDiskMonitorWithChan invokes the ebs.StopDiskMonitor API asynchronously
func (client *Client) StopDiskMonitorWithChan(request *StopDiskMonitorRequest) (<-chan *StopDiskMonitorResponse, <-chan error) {
	responseChan := make(chan *StopDiskMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDiskMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDiskMonitorWithCallback invokes the ebs.StopDiskMonitor API asynchronously
func (client *Client) StopDiskMonitorWithCallback(request *StopDiskMonitorRequest, callback func(response *StopDiskMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDiskMonitorResponse
		var err error
		defer close(result)
		response, err = client.StopDiskMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDiskMonitorRequest is the request struct for api StopDiskMonitor
type StopDiskMonitorRequest struct {
	*requests.RpcRequest
	DiskIds *[]string `position:"Query" name:"DiskIds"  type:"Json"`
}

// StopDiskMonitorResponse is the response struct for api StopDiskMonitor
type StopDiskMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopDiskMonitorRequest creates a request to invoke StopDiskMonitor API
func CreateStopDiskMonitorRequest() (request *StopDiskMonitorRequest) {
	request = &StopDiskMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "StopDiskMonitor", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopDiskMonitorResponse creates a response to parse from StopDiskMonitor response
func CreateStopDiskMonitorResponse() (response *StopDiskMonitorResponse) {
	response = &StopDiskMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
