package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDiagnosticReports invokes the ecs.DeleteDiagnosticReports API synchronously
func (client *Client) DeleteDiagnosticReports(request *DeleteDiagnosticReportsRequest) (response *DeleteDiagnosticReportsResponse, err error) {
	response = CreateDeleteDiagnosticReportsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDiagnosticReportsWithChan invokes the ecs.DeleteDiagnosticReports API asynchronously
func (client *Client) DeleteDiagnosticReportsWithChan(request *DeleteDiagnosticReportsRequest) (<-chan *DeleteDiagnosticReportsResponse, <-chan error) {
	responseChan := make(chan *DeleteDiagnosticReportsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDiagnosticReports(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDiagnosticReportsWithCallback invokes the ecs.DeleteDiagnosticReports API asynchronously
func (client *Client) DeleteDiagnosticReportsWithCallback(request *DeleteDiagnosticReportsRequest, callback func(response *DeleteDiagnosticReportsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDiagnosticReportsResponse
		var err error
		defer close(result)
		response, err = client.DeleteDiagnosticReports(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDiagnosticReportsRequest is the request struct for api DeleteDiagnosticReports
type DeleteDiagnosticReportsRequest struct {
	*requests.RpcRequest
	ReportIds *[]string `position:"Query" name:"ReportIds"  type:"Repeated"`
}

// DeleteDiagnosticReportsResponse is the response struct for api DeleteDiagnosticReports
type DeleteDiagnosticReportsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDiagnosticReportsRequest creates a request to invoke DeleteDiagnosticReports API
func CreateDeleteDiagnosticReportsRequest() (request *DeleteDiagnosticReportsRequest) {
	request = &DeleteDiagnosticReportsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteDiagnosticReports", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDiagnosticReportsResponse creates a response to parse from DeleteDiagnosticReports response
func CreateDeleteDiagnosticReportsResponse() (response *DeleteDiagnosticReportsResponse) {
	response = &DeleteDiagnosticReportsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
