package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateInstanceChargeType invokes the elasticsearch.UpdateInstanceChargeType API synchronously
func (client *Client) UpdateInstanceChargeType(request *UpdateInstanceChargeTypeRequest) (response *UpdateInstanceChargeTypeResponse, err error) {
	response = CreateUpdateInstanceChargeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateInstanceChargeTypeWithChan invokes the elasticsearch.UpdateInstanceChargeType API asynchronously
func (client *Client) UpdateInstanceChargeTypeWithChan(request *UpdateInstanceChargeTypeRequest) (<-chan *UpdateInstanceChargeTypeResponse, <-chan error) {
	responseChan := make(chan *UpdateInstanceChargeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateInstanceChargeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateInstanceChargeTypeWithCallback invokes the elasticsearch.UpdateInstanceChargeType API asynchronously
func (client *Client) UpdateInstanceChargeTypeWithCallback(request *UpdateInstanceChargeTypeRequest, callback func(response *UpdateInstanceChargeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateInstanceChargeTypeResponse
		var err error
		defer close(result)
		response, err = client.UpdateInstanceChargeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateInstanceChargeTypeRequest is the request struct for api UpdateInstanceChargeType
type UpdateInstanceChargeTypeRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
	Body        string `position:"Body" name:"body"`
}

// UpdateInstanceChargeTypeResponse is the response struct for api UpdateInstanceChargeType
type UpdateInstanceChargeTypeResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateInstanceChargeTypeRequest creates a request to invoke UpdateInstanceChargeType API
func CreateUpdateInstanceChargeTypeRequest() (request *UpdateInstanceChargeTypeRequest) {
	request = &UpdateInstanceChargeTypeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateInstanceChargeType", "/openapi/instances/[InstanceId]/actions/convert-pay-type", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateInstanceChargeTypeResponse creates a response to parse from UpdateInstanceChargeType response
func CreateUpdateInstanceChargeTypeResponse() (response *UpdateInstanceChargeTypeResponse) {
	response = &UpdateInstanceChargeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
