package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteStorageVolume invokes the ens.DeleteStorageVolume API synchronously
func (client *Client) DeleteStorageVolume(request *DeleteStorageVolumeRequest) (response *DeleteStorageVolumeResponse, err error) {
	response = CreateDeleteStorageVolumeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteStorageVolumeWithChan invokes the ens.DeleteStorageVolume API asynchronously
func (client *Client) DeleteStorageVolumeWithChan(request *DeleteStorageVolumeRequest) (<-chan *DeleteStorageVolumeResponse, <-chan error) {
	responseChan := make(chan *DeleteStorageVolumeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteStorageVolume(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteStorageVolumeWithCallback invokes the ens.DeleteStorageVolume API asynchronously
func (client *Client) DeleteStorageVolumeWithCallback(request *DeleteStorageVolumeRequest, callback func(response *DeleteStorageVolumeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteStorageVolumeResponse
		var err error
		defer close(result)
		response, err = client.DeleteStorageVolume(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteStorageVolumeRequest is the request struct for api DeleteStorageVolume
type DeleteStorageVolumeRequest struct {
	*requests.RpcRequest
	VolumeId string `position:"Query" name:"VolumeId"`
}

// DeleteStorageVolumeResponse is the response struct for api DeleteStorageVolume
type DeleteStorageVolumeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteStorageVolumeRequest creates a request to invoke DeleteStorageVolume API
func CreateDeleteStorageVolumeRequest() (request *DeleteStorageVolumeRequest) {
	request = &DeleteStorageVolumeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteStorageVolume", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteStorageVolumeResponse creates a response to parse from DeleteStorageVolume response
func CreateDeleteStorageVolumeResponse() (response *DeleteStorageVolumeResponse) {
	response = &DeleteStorageVolumeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
