package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DistApplicationData invokes the ens.DistApplicationData API synchronously
func (client *Client) DistApplicationData(request *DistApplicationDataRequest) (response *DistApplicationDataResponse, err error) {
	response = CreateDistApplicationDataResponse()
	err = client.DoAction(request, response)
	return
}

// DistApplicationDataWithChan invokes the ens.DistApplicationData API asynchronously
func (client *Client) DistApplicationDataWithChan(request *DistApplicationDataRequest) (<-chan *DistApplicationDataResponse, <-chan error) {
	responseChan := make(chan *DistApplicationDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DistApplicationData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DistApplicationDataWithCallback invokes the ens.DistApplicationData API asynchronously
func (client *Client) DistApplicationDataWithCallback(request *DistApplicationDataRequest, callback func(response *DistApplicationDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DistApplicationDataResponse
		var err error
		defer close(result)
		response, err = client.DistApplicationData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DistApplicationDataRequest is the request struct for api DistApplicationData
type DistApplicationDataRequest struct {
	*requests.RpcRequest
	Data         string `position:"Query" name:"Data"`
	DistStrategy string `position:"Query" name:"DistStrategy"`
	AppId        string `position:"Query" name:"AppId"`
}

// DistApplicationDataResponse is the response struct for api DistApplicationData
type DistApplicationDataResponse struct {
	*responses.BaseResponse
	RequestId              string                           `json:"RequestId" xml:"RequestId"`
	DistInstanceTotalCount int                              `json:"DistInstanceTotalCount" xml:"DistInstanceTotalCount"`
	DistInstanceIds        DistInstanceIds                  `json:"DistInstanceIds" xml:"DistInstanceIds"`
	DistResults            DistResultsInDistApplicationData `json:"DistResults" xml:"DistResults"`
}

// CreateDistApplicationDataRequest creates a request to invoke DistApplicationData API
func CreateDistApplicationDataRequest() (request *DistApplicationDataRequest) {
	request = &DistApplicationDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DistApplicationData", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDistApplicationDataResponse creates a response to parse from DistApplicationData response
func CreateDistApplicationDataResponse() (response *DistApplicationDataResponse) {
	response = &DistApplicationDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
