package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLdpsResourceCost invokes the hitsdb.GetLdpsResourceCost API synchronously
func (client *Client) GetLdpsResourceCost(request *GetLdpsResourceCostRequest) (response *GetLdpsResourceCostResponse, err error) {
	response = CreateGetLdpsResourceCostResponse()
	err = client.DoAction(request, response)
	return
}

// GetLdpsResourceCostWithChan invokes the hitsdb.GetLdpsResourceCost API asynchronously
func (client *Client) GetLdpsResourceCostWithChan(request *GetLdpsResourceCostRequest) (<-chan *GetLdpsResourceCostResponse, <-chan error) {
	responseChan := make(chan *GetLdpsResourceCostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLdpsResourceCost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLdpsResourceCostWithCallback invokes the hitsdb.GetLdpsResourceCost API asynchronously
func (client *Client) GetLdpsResourceCostWithCallback(request *GetLdpsResourceCostRequest, callback func(response *GetLdpsResourceCostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLdpsResourceCostResponse
		var err error
		defer close(result)
		response, err = client.GetLdpsResourceCost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLdpsResourceCostRequest is the request struct for api GetLdpsResourceCost
type GetLdpsResourceCostRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartTime            requests.Integer `position:"Query" name:"StartTime"`
	JobId                string           `position:"Query" name:"JobId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              requests.Integer `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// GetLdpsResourceCostResponse is the response struct for api GetLdpsResourceCost
type GetLdpsResourceCostResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	InstanceId    string `json:"InstanceId" xml:"InstanceId"`
	JobId         string `json:"JobId" xml:"JobId"`
	StartTime     int64  `json:"StartTime" xml:"StartTime"`
	EndTime       int64  `json:"EndTime" xml:"EndTime"`
	TotalResource int64  `json:"TotalResource" xml:"TotalResource"`
}

// CreateGetLdpsResourceCostRequest creates a request to invoke GetLdpsResourceCost API
func CreateGetLdpsResourceCostRequest() (request *GetLdpsResourceCostRequest) {
	request = &GetLdpsResourceCostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "GetLdpsResourceCost", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLdpsResourceCostResponse creates a response to parse from GetLdpsResourceCost response
func CreateGetLdpsResourceCostResponse() (response *GetLdpsResourceCostResponse) {
	response = &GetLdpsResourceCostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
