package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveImageSubtitles invokes the imageenhan.RemoveImageSubtitles API synchronously
func (client *Client) RemoveImageSubtitles(request *RemoveImageSubtitlesRequest) (response *RemoveImageSubtitlesResponse, err error) {
	response = CreateRemoveImageSubtitlesResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveImageSubtitlesWithChan invokes the imageenhan.RemoveImageSubtitles API asynchronously
func (client *Client) RemoveImageSubtitlesWithChan(request *RemoveImageSubtitlesRequest) (<-chan *RemoveImageSubtitlesResponse, <-chan error) {
	responseChan := make(chan *RemoveImageSubtitlesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveImageSubtitles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveImageSubtitlesWithCallback invokes the imageenhan.RemoveImageSubtitles API asynchronously
func (client *Client) RemoveImageSubtitlesWithCallback(request *RemoveImageSubtitlesRequest, callback func(response *RemoveImageSubtitlesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveImageSubtitlesResponse
		var err error
		defer close(result)
		response, err = client.RemoveImageSubtitles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveImageSubtitlesRequest is the request struct for api RemoveImageSubtitles
type RemoveImageSubtitlesRequest struct {
	*requests.RpcRequest
	BH       requests.Float `position:"Body" name:"BH"`
	BW       requests.Float `position:"Body" name:"BW"`
	BX       requests.Float `position:"Body" name:"BX"`
	BY       requests.Float `position:"Body" name:"BY"`
	ImageURL string         `position:"Body" name:"ImageURL"`
}

// RemoveImageSubtitlesResponse is the response struct for api RemoveImageSubtitles
type RemoveImageSubtitlesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRemoveImageSubtitlesRequest creates a request to invoke RemoveImageSubtitles API
func CreateRemoveImageSubtitlesRequest() (request *RemoveImageSubtitlesRequest) {
	request = &RemoveImageSubtitlesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "RemoveImageSubtitles", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveImageSubtitlesResponse creates a response to parse from RemoveImageSubtitles response
func CreateRemoveImageSubtitlesResponse() (response *RemoveImageSubtitlesResponse) {
	response = &RemoveImageSubtitlesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
