package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchRegisterDevice invokes the iot.BatchRegisterDevice API synchronously
func (client *Client) BatchRegisterDevice(request *BatchRegisterDeviceRequest) (response *BatchRegisterDeviceResponse, err error) {
	response = CreateBatchRegisterDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BatchRegisterDeviceWithChan invokes the iot.BatchRegisterDevice API asynchronously
func (client *Client) BatchRegisterDeviceWithChan(request *BatchRegisterDeviceRequest) (<-chan *BatchRegisterDeviceResponse, <-chan error) {
	responseChan := make(chan *BatchRegisterDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchRegisterDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchRegisterDeviceWithCallback invokes the iot.BatchRegisterDevice API asynchronously
func (client *Client) BatchRegisterDeviceWithCallback(request *BatchRegisterDeviceRequest, callback func(response *BatchRegisterDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchRegisterDeviceResponse
		var err error
		defer close(result)
		response, err = client.BatchRegisterDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchRegisterDeviceRequest is the request struct for api BatchRegisterDevice
type BatchRegisterDeviceRequest struct {
	*requests.RpcRequest
	RealTenantId      string           `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string           `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId     string           `position:"Query" name:"IotInstanceId"`
	Count             requests.Integer `position:"Query" name:"Count"`
	ProductKey        string           `position:"Query" name:"ProductKey"`
	ApiProduct        string           `position:"Body" name:"ApiProduct"`
	ApiRevision       string           `position:"Body" name:"ApiRevision"`
}

// BatchRegisterDeviceResponse is the response struct for api BatchRegisterDevice
type BatchRegisterDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateBatchRegisterDeviceRequest creates a request to invoke BatchRegisterDevice API
func CreateBatchRegisterDeviceRequest() (request *BatchRegisterDeviceRequest) {
	request = &BatchRegisterDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchRegisterDevice", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchRegisterDeviceResponse creates a response to parse from BatchRegisterDevice response
func CreateBatchRegisterDeviceResponse() (response *BatchRegisterDeviceResponse) {
	response = &BatchRegisterDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
