package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePhoneInfo invokes the jarvis.DescribePhoneInfo API synchronously
// api document: https://help.aliyun.com/api/jarvis/describephoneinfo.html
func (client *Client) DescribePhoneInfo(request *DescribePhoneInfoRequest) (response *DescribePhoneInfoResponse, err error) {
	response = CreateDescribePhoneInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePhoneInfoWithChan invokes the jarvis.DescribePhoneInfo API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describephoneinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePhoneInfoWithChan(request *DescribePhoneInfoRequest) (<-chan *DescribePhoneInfoResponse, <-chan error) {
	responseChan := make(chan *DescribePhoneInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePhoneInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePhoneInfoWithCallback invokes the jarvis.DescribePhoneInfo API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describephoneinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePhoneInfoWithCallback(request *DescribePhoneInfoRequest, callback func(response *DescribePhoneInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePhoneInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribePhoneInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePhoneInfoRequest is the request struct for api DescribePhoneInfo
type DescribePhoneInfoRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	PhoneNum   string `position:"Query" name:"phoneNum"`
	Lang       string `position:"Query" name:"Lang"`
	SourceCode string `position:"Query" name:"sourceCode"`
}

// DescribePhoneInfoResponse is the response struct for api DescribePhoneInfo
type DescribePhoneInfoResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Module     string `json:"Module" xml:"Module"`
	PhoneNum   int    `json:"phoneNum" xml:"phoneNum"`
	RiskLevel  int    `json:"riskLevel" xml:"riskLevel"`
	DetectTime string `json:"detectTime" xml:"detectTime"`
}

// CreateDescribePhoneInfoRequest creates a request to invoke DescribePhoneInfo API
func CreateDescribePhoneInfoRequest() (request *DescribePhoneInfoRequest) {
	request = &DescribePhoneInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribePhoneInfo", "jarvis", "openAPI")
	return
}

// CreateDescribePhoneInfoResponse creates a response to parse from DescribePhoneInfo response
func CreateDescribePhoneInfoResponse() (response *DescribePhoneInfoResponse) {
	response = &DescribePhoneInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
