package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFaceUserGroup invokes the linkvisual.AddFaceUserGroup API synchronously
func (client *Client) AddFaceUserGroup(request *AddFaceUserGroupRequest) (response *AddFaceUserGroupResponse, err error) {
	response = CreateAddFaceUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddFaceUserGroupWithChan invokes the linkvisual.AddFaceUserGroup API asynchronously
func (client *Client) AddFaceUserGroupWithChan(request *AddFaceUserGroupRequest) (<-chan *AddFaceUserGroupResponse, <-chan error) {
	responseChan := make(chan *AddFaceUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFaceUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFaceUserGroupWithCallback invokes the linkvisual.AddFaceUserGroup API asynchronously
func (client *Client) AddFaceUserGroupWithCallback(request *AddFaceUserGroupRequest, callback func(response *AddFaceUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFaceUserGroupResponse
		var err error
		defer close(result)
		response, err = client.AddFaceUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFaceUserGroupRequest is the request struct for api AddFaceUserGroup
type AddFaceUserGroupRequest struct {
	*requests.RpcRequest
	IsolationId   string `position:"Query" name:"IsolationId"`
	UserGroupName string `position:"Query" name:"UserGroupName"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// AddFaceUserGroupResponse is the response struct for api AddFaceUserGroup
type AddFaceUserGroupResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateAddFaceUserGroupRequest creates a request to invoke AddFaceUserGroup API
func CreateAddFaceUserGroupRequest() (request *AddFaceUserGroupRequest) {
	request = &AddFaceUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "AddFaceUserGroup", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFaceUserGroupResponse creates a response to parse from AddFaceUserGroup response
func CreateAddFaceUserGroupResponse() (response *AddFaceUserGroupResponse) {
	response = &AddFaceUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
