package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveEdgeTransfer invokes the live.DeleteLiveEdgeTransfer API synchronously
func (client *Client) DeleteLiveEdgeTransfer(request *DeleteLiveEdgeTransferRequest) (response *DeleteLiveEdgeTransferResponse, err error) {
	response = CreateDeleteLiveEdgeTransferResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveEdgeTransferWithChan invokes the live.DeleteLiveEdgeTransfer API asynchronously
func (client *Client) DeleteLiveEdgeTransferWithChan(request *DeleteLiveEdgeTransferRequest) (<-chan *DeleteLiveEdgeTransferResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveEdgeTransferResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveEdgeTransfer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveEdgeTransferWithCallback invokes the live.DeleteLiveEdgeTransfer API asynchronously
func (client *Client) DeleteLiveEdgeTransferWithCallback(request *DeleteLiveEdgeTransferRequest, callback func(response *DeleteLiveEdgeTransferResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveEdgeTransferResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveEdgeTransfer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveEdgeTransferRequest is the request struct for api DeleteLiveEdgeTransfer
type DeleteLiveEdgeTransferRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLiveEdgeTransferResponse is the response struct for api DeleteLiveEdgeTransfer
type DeleteLiveEdgeTransferResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveEdgeTransferRequest creates a request to invoke DeleteLiveEdgeTransfer API
func CreateDeleteLiveEdgeTransferRequest() (request *DeleteLiveEdgeTransferRequest) {
	request = &DeleteLiveEdgeTransferRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveEdgeTransfer", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveEdgeTransferResponse creates a response to parse from DeleteLiveEdgeTransfer response
func CreateDeleteLiveEdgeTransferResponse() (response *DeleteLiveEdgeTransferResponse) {
	response = &DeleteLiveEdgeTransferResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
