package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveSnapshotDetectPornConfig invokes the live.DescribeLiveSnapshotDetectPornConfig API synchronously
func (client *Client) DescribeLiveSnapshotDetectPornConfig(request *DescribeLiveSnapshotDetectPornConfigRequest) (response *DescribeLiveSnapshotDetectPornConfigResponse, err error) {
	response = CreateDescribeLiveSnapshotDetectPornConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveSnapshotDetectPornConfigWithChan invokes the live.DescribeLiveSnapshotDetectPornConfig API asynchronously
func (client *Client) DescribeLiveSnapshotDetectPornConfigWithChan(request *DescribeLiveSnapshotDetectPornConfigRequest) (<-chan *DescribeLiveSnapshotDetectPornConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveSnapshotDetectPornConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveSnapshotDetectPornConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveSnapshotDetectPornConfigWithCallback invokes the live.DescribeLiveSnapshotDetectPornConfig API asynchronously
func (client *Client) DescribeLiveSnapshotDetectPornConfigWithCallback(request *DescribeLiveSnapshotDetectPornConfigRequest, callback func(response *DescribeLiveSnapshotDetectPornConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveSnapshotDetectPornConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveSnapshotDetectPornConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveSnapshotDetectPornConfigRequest is the request struct for api DescribeLiveSnapshotDetectPornConfig
type DescribeLiveSnapshotDetectPornConfigRequest struct {
	*requests.RpcRequest
	PageNum       requests.Integer `position:"Query" name:"PageNum"`
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Order         string           `position:"Query" name:"Order"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveSnapshotDetectPornConfigResponse is the response struct for api DescribeLiveSnapshotDetectPornConfig
type DescribeLiveSnapshotDetectPornConfigResponse struct {
	*responses.BaseResponse
	PageNum                          int                              `json:"PageNum" xml:"PageNum"`
	RequestId                        string                           `json:"RequestId" xml:"RequestId"`
	Order                            string                           `json:"Order" xml:"Order"`
	TotalPage                        int                              `json:"TotalPage" xml:"TotalPage"`
	PageSize                         int                              `json:"PageSize" xml:"PageSize"`
	TotalNum                         int                              `json:"TotalNum" xml:"TotalNum"`
	LiveSnapshotDetectPornConfigList LiveSnapshotDetectPornConfigList `json:"LiveSnapshotDetectPornConfigList" xml:"LiveSnapshotDetectPornConfigList"`
}

// CreateDescribeLiveSnapshotDetectPornConfigRequest creates a request to invoke DescribeLiveSnapshotDetectPornConfig API
func CreateDescribeLiveSnapshotDetectPornConfigRequest() (request *DescribeLiveSnapshotDetectPornConfigRequest) {
	request = &DescribeLiveSnapshotDetectPornConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveSnapshotDetectPornConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveSnapshotDetectPornConfigResponse creates a response to parse from DescribeLiveSnapshotDetectPornConfig response
func CreateDescribeLiveSnapshotDetectPornConfigResponse() (response *DescribeLiveSnapshotDetectPornConfigResponse) {
	response = &DescribeLiveSnapshotDetectPornConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
