package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveSnapshotNotifyConfig invokes the live.DescribeLiveSnapshotNotifyConfig API synchronously
func (client *Client) DescribeLiveSnapshotNotifyConfig(request *DescribeLiveSnapshotNotifyConfigRequest) (response *DescribeLiveSnapshotNotifyConfigResponse, err error) {
	response = CreateDescribeLiveSnapshotNotifyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveSnapshotNotifyConfigWithChan invokes the live.DescribeLiveSnapshotNotifyConfig API asynchronously
func (client *Client) DescribeLiveSnapshotNotifyConfigWithChan(request *DescribeLiveSnapshotNotifyConfigRequest) (<-chan *DescribeLiveSnapshotNotifyConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveSnapshotNotifyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveSnapshotNotifyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveSnapshotNotifyConfigWithCallback invokes the live.DescribeLiveSnapshotNotifyConfig API asynchronously
func (client *Client) DescribeLiveSnapshotNotifyConfigWithCallback(request *DescribeLiveSnapshotNotifyConfigRequest, callback func(response *DescribeLiveSnapshotNotifyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveSnapshotNotifyConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveSnapshotNotifyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveSnapshotNotifyConfigRequest is the request struct for api DescribeLiveSnapshotNotifyConfig
type DescribeLiveSnapshotNotifyConfigRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveSnapshotNotifyConfigResponse is the response struct for api DescribeLiveSnapshotNotifyConfig
type DescribeLiveSnapshotNotifyConfigResponse struct {
	*responses.BaseResponse
	DomainName    string `json:"DomainName" xml:"DomainName"`
	NotifyAuthKey string `json:"NotifyAuthKey" xml:"NotifyAuthKey"`
	NotifyReqAuth string `json:"NotifyReqAuth" xml:"NotifyReqAuth"`
	NotifyUrl     string `json:"NotifyUrl" xml:"NotifyUrl"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeLiveSnapshotNotifyConfigRequest creates a request to invoke DescribeLiveSnapshotNotifyConfig API
func CreateDescribeLiveSnapshotNotifyConfigRequest() (request *DescribeLiveSnapshotNotifyConfigRequest) {
	request = &DescribeLiveSnapshotNotifyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveSnapshotNotifyConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveSnapshotNotifyConfigResponse creates a response to parse from DescribeLiveSnapshotNotifyConfig response
func CreateDescribeLiveSnapshotNotifyConfigResponse() (response *DescribeLiveSnapshotNotifyConfigResponse) {
	response = &DescribeLiveSnapshotNotifyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
