package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMessageApp invokes the live.QueryMessageApp API synchronously
func (client *Client) QueryMessageApp(request *QueryMessageAppRequest) (response *QueryMessageAppResponse, err error) {
	response = CreateQueryMessageAppResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMessageAppWithChan invokes the live.QueryMessageApp API asynchronously
func (client *Client) QueryMessageAppWithChan(request *QueryMessageAppRequest) (<-chan *QueryMessageAppResponse, <-chan error) {
	responseChan := make(chan *QueryMessageAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMessageApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMessageAppWithCallback invokes the live.QueryMessageApp API asynchronously
func (client *Client) QueryMessageAppWithCallback(request *QueryMessageAppRequest, callback func(response *QueryMessageAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMessageAppResponse
		var err error
		defer close(result)
		response, err = client.QueryMessageApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMessageAppRequest is the request struct for api QueryMessageApp
type QueryMessageAppRequest struct {
	*requests.RpcRequest
	SortType requests.Integer `position:"Body" name:"SortType"`
	PageNum  requests.Integer `position:"Body" name:"PageNum"`
	AppName  string           `position:"Body" name:"AppName"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
	AppId    string           `position:"Body" name:"AppId"`
}

// QueryMessageAppResponse is the response struct for api QueryMessageApp
type QueryMessageAppResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateQueryMessageAppRequest creates a request to invoke QueryMessageApp API
func CreateQueryMessageAppRequest() (request *QueryMessageAppRequest) {
	request = &QueryMessageAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "QueryMessageApp", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryMessageAppResponse creates a response to parse from QueryMessageApp response
func CreateQueryMessageAppResponse() (response *QueryMessageAppResponse) {
	response = &QueryMessageAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
